package com.amity.socialcloud.sdk.social.data.poll

import com.amity.socialcloud.sdk.model.social.poll.AmityPollAnswer
import com.google.gson.JsonArray
import com.google.gson.JsonObject

internal class PollRepositoryHelper {

    fun convertAnswersToJsonArray(answers: List<AmityPollAnswer.Data>): JsonArray {
        return JsonArray().apply {
            answers.forEach {
                if (it is AmityPollAnswer.Data.TEXT) {
                    add(JsonObject().apply {
                        addProperty("dataType", it.apiKey)
                        addProperty("data", it.data)
                    })
                }
            }
        }
    }

}