package com.amity.socialcloud.sdk.core.data.presence

import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.entity.UserPresenceEntity
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class PresenceLocalDataStore {

    fun saveUserPresence(userPresences: List<UserPresenceEntity>): Completable {
        return Completable.fromAction {
            UserDatabase.get().userPresenceDao().save(userPresences)
        }
    }

    fun getUserPresence(userId: String): UserPresenceEntity? {
        var userPresence: UserPresenceEntity? = null
        Completable.fromCallable {
            val entity = UserDatabase.get().userPresenceDao().getByUserIdNow(userId)
            if (entity != null) {
                userPresence = entity
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return userPresence
    }
    
    fun getUserPresenceNow(userId: String): UserPresenceEntity? {
        var userPresence: UserPresenceEntity? = null
        val entity = UserDatabase.get().userPresenceDao().getByUserIdNow(userId)
        if (entity != null) {
            userPresence = entity
        }
        return userPresence
    }
}