/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.chat.message;

import com.amity.socialcloud.sdk.api.chat.message.create.AmityMessageCreationTarget;
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuery;
import com.amity.socialcloud.sdk.api.chat.message.reaction.AmityMessageReactionQuery;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage;
import com.ekoapp.ekosdk.internal.usecase.message.MessageDeleteUseCase;
import com.ekoapp.ekosdk.internal.usecase.message.MessageLiveObjectUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lcom/amity/socialcloud/sdk/api/chat/message/AmityMessageRepository;", "", "()V", "createMessage", "Lcom/amity/socialcloud/sdk/api/chat/message/create/AmityMessageCreationTarget$Builder;", "subChannelId", "", "deleteMessage", "Lio/reactivex/rxjava3/core/Completable;", "messageId", "getMessage", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage;", "getMessages", "Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuery$Builder;", "getReactions", "Lcom/amity/socialcloud/sdk/api/chat/message/reaction/AmityMessageReactionQuery$Builder;", "amity-sdk_release"})
public final class AmityMessageRepository {
    @NotNull
    public final AmityMessageQuery.Builder getMessages(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        return new AmityMessageQuery.Builder(subChannelId);
    }

    @NotNull
    public final Flowable<AmityMessage> getMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new MessageLiveObjectUseCase().execute(messageId);
    }

    @NotNull
    public final AmityMessageCreationTarget.Builder createMessage(@NotNull String subChannelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        return new AmityMessageCreationTarget.Builder(subChannelId);
    }

    @NotNull
    public final Completable deleteMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new MessageDeleteUseCase().execute(messageId);
    }

    @NotNull
    public final AmityMessageReactionQuery.Builder getReactions(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new AmityMessageReactionQuery.Builder(messageId);
    }
}

