package com.amity.socialcloud.sdk.api.chat.member

import com.amity.socialcloud.sdk.api.chat.AmityChatClient
import com.amity.socialcloud.sdk.chat.domain.channel.moderation.*
import com.amity.socialcloud.sdk.chat.domain.channel.participation.AddUsersChannelParticipationUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.participation.RemoveUsersChannelParticipationUseCase
import io.reactivex.rxjava3.core.Completable
import org.joda.time.Duration


class AmityChannelModeration internal constructor(private val channelId: String) {

    internal fun addMembers(userIds: List<String>): Completable {
        return AddUsersChannelParticipationUseCase().execute(channelId, userIds)
    }

    internal fun removeMembers(userIds: List<String>): Completable {
        return RemoveUsersChannelParticipationUseCase().execute(channelId, userIds)
    }
    
    /* begin_public_function
	  id: channel.moderation.add_roles
	*/
    fun addRole(role: String, userIds: List<String>): Completable {
        return AddRoleUseCase().execute(channelId, role, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.moderation.remove_roles
	*/
    fun removeRole(role: String, userIds: List<String>): Completable {
        return RemoveRoleUseCase().execute(channelId, role, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.moderation.mute_members
	*/
    fun muteMembers(timeout: Duration, userIds: List<String>): Completable {
        return MuteUsersChannelUseCase().execute(channelId, timeout, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.moderation.unmute_members
	*/
    fun unmuteMembers(userIds: List<String>): Completable {
        return UnMuteUsersChannelUseCase().execute(channelId, userIds)
    }
    /* end_public_function */

    @Deprecated("Use AmityChatClient.newChannelRepository().muteChannel(...) instead")
    fun muteChannel(timeout: Duration): Completable {
        return AmityChatClient.newChannelRepository().muteChannel(channelId, timeout)
    }

    @Deprecated("Use AmityChatClient.newChannelRepository().unmuteChannel(...) instead")
    fun unmuteChannel(): Completable {
        return AmityChatClient.newChannelRepository().unmuteChannel(channelId)
    }

    /* begin_public_function
	  id: channel.moderation.ban_members
	*/
    fun banMembers(userIds: List<String>): Completable {
        return BanUsersChannelUseCase().execute(channelId, userIds)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: channel.moderation.unban_members
	*/
    fun unbanMembers(userIds: List<String>): Completable {
        return UnBanUsersChannelUseCase().execute(channelId, userIds)
    }
    /* end_public_function */

}