/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.domain.session;

import com.amity.socialcloud.sdk.core.data.session.SessionRepository;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionLifeCycle;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/amity/socialcloud/sdk/core/domain/session/LoginUseCase;", "", "()V", "execute", "Lio/reactivex/rxjava3/core/Single;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "userId", "", "displayName", "authToken", "isLegacyVersion", "", "verifyUserId", "", "amity-sdk_release"})
public final class LoginUseCase {
    @NotNull
    public final Single<EkoAccount> execute(@Nullable AppEventBus appEventBus, @Nullable SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull String userId, @Nullable String displayName, @Nullable String authToken, boolean isLegacyVersion) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.verifyUserId(appEventBus, userId);
        AppEventBus appEventBus2 = appEventBus;
        if (appEventBus2 != null) {
            appEventBus2.publish(AppEvent.LoggingIn.INSTANCE);
        }
        Single single = new SessionRepository().login(userId, displayName, authToken, isLegacyVersion).andThen((SingleSource)new SessionRepository().getCurrentAccount()).doOnSuccess(new Consumer(appEventBus, sessionLifeCycleEventBus){
            final /* synthetic */ AppEventBus $appEventBus;
            final /* synthetic */ SessionLifeCycleEventBus $sessionLifeCycleEventBus;
            {
                this.$appEventBus = $appEventBus;
                this.$sessionLifeCycleEventBus = $sessionLifeCycleEventBus;
            }

            public final void accept(@NotNull EkoAccount it) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AppEventBus appEventBus = this.$appEventBus;
                    if (appEventBus != null) {
                        appEventBus.publish(AppEvent.LoginSuccess.INSTANCE);
                    }
                    SessionLifeCycleEventBus sessionLifeCycleEventBus = this.$sessionLifeCycleEventBus;
                    if (sessionLifeCycleEventBus == null) break block1;
                    sessionLifeCycleEventBus.publish(new SessionLifeCycle.Establish(it));
                }
            }
        }).doOnError(new Consumer(appEventBus){
            final /* synthetic */ AppEventBus $appEventBus;
            {
                this.$appEventBus = $appEventBus;
            }

            public final void accept(@NotNull Throwable it) {
                block1: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        AmityException amityError = AmityException.Companion.fromThrowable(it);
                        if (amityError.getCode() != AmityError.USER_IS_GLOBAL_BANNED.getCode() && amityError.getCode() != AmityError.UNAUTHORIZED_ERROR.getCode()) break block0;
                        AppEventBus appEventBus = this.$appEventBus;
                        if (appEventBus == null) break block1;
                        appEventBus.publish(new AppEvent.TerminationCodeReceive(amityError));
                        break block1;
                    }
                    AppEventBus appEventBus = this.$appEventBus;
                    if (appEventBus == null) break block1;
                    appEventBus.publish(AppEvent.LoginFail.INSTANCE);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"appEventBus: AppEventBus\u2026          }\n            }");
        return single;
    }

    private final void verifyUserId(AppEventBus appEventBus, String userId) {
        block1: {
            String currentUserId = new ActiveUserIdGetUseCase().execute();
            if (!(((CharSequence)currentUserId).length() > 0) || Intrinsics.areEqual((Object)userId, (Object)currentUserId)) break block1;
            AppEventBus appEventBus2 = appEventBus;
            if (appEventBus2 != null) {
                appEventBus2.publish(AppEvent.ManualLogout.INSTANCE);
            }
        }
    }
}

