/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.stream;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\bJ \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\bJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\bJ\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/video/data/stream/StreamLocalDataStore;", "", "()V", "getLatestStream", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/entity/video/stream/EkoStreamEntity;", "statuses", "", "", "getStream", "streamId", "getStreamsPagingSource", "Landroidx/paging/PagingSource;", "", "notifyChanges", "", "observeStream", "saveStream", "Lio/reactivex/rxjava3/core/Completable;", "streams", "amity-sdk_release"})
public final class StreamLocalDataStore {
    @NotNull
    public final Completable saveStream(@NotNull List<? extends EkoStreamEntity> streams) {
        Intrinsics.checkNotNullParameter(streams, (String)"streams");
        Completable completable = Completable.fromAction(() -> StreamLocalDataStore.saveStream$lambda$0(streams));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction { UserDatabas\u2026reamDao().save(streams) }");
        return completable;
    }

    @Nullable
    public final EkoStreamEntity getStream(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Ref.ObjectRef stream = new Ref.ObjectRef();
        Completable.fromCallable(() -> StreamLocalDataStore.getStream$lambda$1(streamId, stream)).subscribeOn(Schedulers.io()).blockingAwait();
        return (EkoStreamEntity)stream.element;
    }

    @NotNull
    public final Flowable<EkoStreamEntity> observeStream(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        return UserDatabase.get().streamDao().getById(streamId);
    }

    @NotNull
    public final PagingSource<Integer, EkoStreamEntity> getStreamsPagingSource(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return UserDatabase.get().streamPagingDao().queryStreamList(statuses);
    }

    @NotNull
    public final Flowable<EkoStreamEntity> getLatestStream(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return UserDatabase.get().streamDao().getLatestStream(statuses);
    }

    public final void notifyChanges(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        UserDatabase.get().streamDao().updateStream(streamId);
    }

    private static final void saveStream$lambda$0(List $streams) {
        Intrinsics.checkNotNullParameter((Object)$streams, (String)"$streams");
        UserDatabase.get().streamDao().save($streams);
    }

    private static final Unit getStream$lambda$1(String $streamId, Ref.ObjectRef $stream) {
        Intrinsics.checkNotNullParameter((Object)$streamId, (String)"$streamId");
        Intrinsics.checkNotNullParameter((Object)$stream, (String)"$stream");
        EkoStreamEntity entity = UserDatabase.get().streamDao().getByIdNow($streamId);
        if (entity != null) {
            $stream.element = entity;
        }
        return Unit.INSTANCE;
    }
}

