/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.usecase;

import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.core.data.tombstone.TombstoneRepository;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.TombstoneModelType;
import com.ekoapp.ekosdk.internal.entity.TombstoneEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\t\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH&J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0013H&J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ekoapp/ekosdk/internal/usecase/LiveObjectUseCase;", "Entity", "Lcom/ekoapp/ekosdk/EkoObject;", "PublicModel", "", "()V", "nullTombstone", "Lcom/ekoapp/ekosdk/internal/entity/TombstoneEntity;", "composeModel", "model", "(Ljava/lang/Object;)Ljava/lang/Object;", "createRepository", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "execute", "Lio/reactivex/rxjava3/core/Flowable;", "objectId", "", "retrieveLiveObject", "tombstoneModelType", "Lcom/ekoapp/ekosdk/internal/TombstoneModelType;", "verifyObjectTombstone", "Lio/reactivex/rxjava3/core/Single;", "", "amity-sdk_release"})
public abstract class LiveObjectUseCase<Entity extends EkoObject, PublicModel> {
    @NotNull
    private final TombstoneEntity nullTombstone;

    /*
     * WARNING - void declaration
     */
    public LiveObjectUseCase() {
        void $this$nullTombstone_u24lambda_u240;
        TombstoneEntity tombstoneEntity;
        TombstoneEntity tombstoneEntity2 = tombstoneEntity = new TombstoneEntity();
        LiveObjectUseCase liveObjectUseCase = this;
        boolean bl = false;
        $this$nullTombstone_u24lambda_u240.setObjectId("NULL_TOMBSTONE");
        liveObjectUseCase.nullTombstone = tombstoneEntity;
    }

    @NotNull
    public abstract AmityObjectRepository<Entity, PublicModel> createRepository();

    @Nullable
    public abstract PublicModel composeModel(@NotNull PublicModel var1);

    @NotNull
    public abstract TombstoneModelType tombstoneModelType();

    @NotNull
    public Flowable<PublicModel> execute(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Flowable flowable = this.verifyObjectTombstone(objectId).flatMapPublisher(new Function(this, objectId){
            final /* synthetic */ LiveObjectUseCase<Entity, PublicModel> this$0;
            final /* synthetic */ String $objectId;
            {
                this.this$0 = $receiver;
                this.$objectId = $objectId;
            }

            @NotNull
            public final Publisher<? extends PublicModel> apply(boolean isObjectValid) {
                if (isObjectValid) {
                    return (Publisher)LiveObjectUseCase.access$retrieveLiveObject(this.this$0, this.$objectId);
                }
                throw AmityException.Companion.create$default(AmityException.Companion, "item not found", null, AmityError.ITEM_NOT_FOUND, null, 8, null);
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"open fun execute(objectI\u2026On(Schedulers.io())\n    }");
        return flowable;
    }

    private final Flowable<PublicModel> retrieveLiveObject(String objectId) {
        Completable completable = this.createRepository().obtain(objectId).ignoreElement().doOnError(new Consumer(objectId, this){
            final /* synthetic */ String $objectId;
            final /* synthetic */ LiveObjectUseCase<Entity, PublicModel> this$0;
            {
                this.$objectId = $objectId;
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    new TombstoneRepository().saveTombstone(this.$objectId, this.this$0.tombstoneModelType(), AmityError.ITEM_NOT_FOUND).subscribeOn(Schedulers.io()).subscribe();
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"private fun retrieveLive\u2026    }\n            }\n    }");
        Completable obtainObject2 = completable;
        Flowable<PublicModel> observe2 = this.createRepository().observe(objectId);
        Flowable flowable = obtainObject2.andThen((Publisher)observe2).map(new Function(this){
            final /* synthetic */ LiveObjectUseCase<Entity, PublicModel> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final PublicModel apply(@NotNull PublicModel result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PublicModel composedModel = this.this$0.composeModel(result);
                if (composedModel != null) {
                    return composedModel;
                }
                return result;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"private fun retrieveLive\u2026    }\n            }\n    }");
        return flowable;
    }

    private final Single<Boolean> verifyObjectTombstone(String objectId) {
        Single single = Single.fromCallable(() -> LiveObjectUseCase.verifyObjectTombstone$lambda$1(objectId, this)).map(new Function(this){
            final /* synthetic */ LiveObjectUseCase<Entity, PublicModel> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final Boolean apply(@NotNull TombstoneEntity tombstone) {
                Intrinsics.checkNotNullParameter((Object)tombstone, (String)"tombstone");
                DateTime dateTime = tombstone.getExpiresAt();
                boolean isExpired = dateTime != null ? dateTime.isBeforeNow() : false;
                boolean isObjectValid = Intrinsics.areEqual((Object)tombstone.getObjectId(), (Object)LiveObjectUseCase.access$getNullTombstone$p(this.this$0).getObjectId()) ? true : isExpired;
                return isObjectValid;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"private fun verifyObject\u2026jectValid\n        }\n    }");
        return single;
    }

    private static final TombstoneEntity verifyObjectTombstone$lambda$1(String $objectId, LiveObjectUseCase this$0) {
        Intrinsics.checkNotNullParameter((Object)$objectId, (String)"$objectId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TombstoneEntity tombstoneEntity = new TombstoneRepository().getTombstone($objectId, this$0.tombstoneModelType());
        if (tombstoneEntity == null) {
            tombstoneEntity = this$0.nullTombstone;
        }
        return tombstoneEntity;
    }

    public static final /* synthetic */ Flowable access$retrieveLiveObject(LiveObjectUseCase $this, String objectId) {
        return $this.retrieveLiveObject(objectId);
    }

    public static final /* synthetic */ TombstoneEntity access$getNullTombstone$p(LiveObjectUseCase $this) {
        return $this.nullTombstone;
    }
}

