package com.amity.socialcloud.sdk.social.data.comment

import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CommentUpdateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.CommentCreateRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface CommentApi {

    @POST("api/v3/comments")
    fun createComment(
        @Body request: CommentCreateRequest
    ): Single<EkoCommentAndUserListDto>

    @PUT("api/v3/comments/{commentId}")
    fun updateComment(
        @Path("commentId") commentId: String,
        @Body request: CommentUpdateRequest
    ): Single<EkoCommentAndUserListDto>

    @DELETE("api/v4/comments/{commentId}")
    fun deleteComment(
        @Path("commentId") commentId: String,
        @Query("permanent") permanent: Boolean
    ): Single<EkoDeletionDto>

    @GET("api/v3/comments")
    fun queryComments(
        @Query("referenceId") referenceId: String? = null,
        @Query("referenceType") referenceType: String? = null,
        @Query("filterByParentId") filterByParentId: Boolean? = null,
        @Query("parentId") parentId: String? = null,
        @Query("isDeleted") isDeleted: Boolean? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[skip]", encoded = true) skip: Int? = null,
        @Query("options[first]", encoded = true) first: Int? = null,
        @Query("options[last]", encoded = true) last: Int? = null,
        @Query("options[type]", encoded = true) type: String? = null,
        @Query("options[token]", encoded = true) token: String? = null,
        @Query("dataTypes[matchType]", encoded = true) matchType: String? = null,
        @Query("dataTypes[values][]", encoded = true) dataTypes: List<String>? = null,
    ): Single<EkoCommentAndUserListDto>

    @POST("api/v3/comments/{commentId}/flag")
    fun flagComment(
        @Path("commentId") commentId: String
    ): Single<EkoCommentAndUserListDto>

    @DELETE("api/v3/comments/{commentId}/unflag")
    fun unflagComment(
        @Path("commentId") commentId: String
    ): Single<EkoCommentAndUserListDto>

    @GET("api/v3/comments/{commentId}/isflagbyme")
    fun isFlaggedByMe(
        @Path("commentId") commentId: String
    ): Single<JsonObject>

    @GET("api/v3/comments/list")
    fun getCommentByIds(
        @Query("commentIds[]") comments: List<String>
    ): Single<EkoCommentAndUserListDto>

}