package com.amity.socialcloud.sdk.entity.core.ad

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.model.core.ad.AmityAdsSettings
import com.amity.socialcloud.sdk.model.core.ad.AmityFrequencySettings
import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.amity.socialcloud.sdk.socket.util.EkoGson
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.joda.time.DateTime


@Entity(tableName = "ads_settings")
open class AdsSettingsEntity(
    @PrimaryKey
    var settingId: String = "ADS_SETTINGS",
    var enabled: Boolean,
    var maxActiveAds: Int,
    var frequency: JsonObject
) : EkoObject() {

    override fun getId(): String {
        return settingId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        if (other.javaClass != javaClass) return false
        return (Objects.equal(settingId, (other as AdsSettingsEntity).settingId)
                && Objects.equal(enabled, other.enabled)
                && Objects.equal(maxActiveAds, other.maxActiveAds)
                && Objects.equal(frequency, other.frequency)
                && Objects.equal(updatedAt, other.updatedAt))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            settingId,
            enabled,
            maxActiveAds,
            frequency,
            updatedAt,
        )
    }

}

fun AdsSettingsEntity.toModel(): AmityAdsSettings {
    return AmityAdsSettings(
        isEnabled = enabled,
        maxActiveAds = maxActiveAds,
        frequency = frequency,
        updatedAt = updatedAt ?: DateTime.now()
    )
}