package com.amity.socialcloud.sdk.dto.core.ad

import com.amity.socialcloud.sdk.entity.core.ad.AdsSettingsEntity
import com.google.gson.JsonObject
import org.joda.time.DateTime

class AdsSettingsDto {
    var enabled: Boolean? = false
    var frequency: JsonObject? = null
    var maxActiveAds: Int? = null
    var updatedAt: DateTime? = null
}

fun AdsSettingsDto.toEntity(): AdsSettingsEntity {
    return AdsSettingsEntity(
        enabled = enabled ?: false,
        maxActiveAds = maxActiveAds ?: 0,
        frequency = frequency ?: JsonObject(),
    ).apply {
        createdAt = updatedAt
        updatedAt = updatedAt
    }
}

