package com.ekoapp.ekosdk.internal.usecase.user

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.core.data.follow.FollowRepository
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowRelationship
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatusFilter
import io.reactivex.rxjava3.core.Flowable

internal class GetUserFollowingsPagingDataUseCase {

    fun execute(userId: String): Flowable<PagingData<AmityFollowRelationship>> {
        return FollowRepository().getFollowingsPagingData(userId, AmityFollowStatusFilter.ACCEPTED)
    }
}