/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.ad;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.EmptyResultSetException;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.data.ad.AdvertiserDao;
import com.amity.socialcloud.sdk.entity.core.ad.AdvertiserEntity;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class AdvertiserDao_Impl
extends AdvertiserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AdvertiserEntity> __insertionAdapterOfAdvertiserEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<AdvertiserEntity> __deletionAdapterOfAdvertiserEntity;
    private final EntityDeletionOrUpdateAdapter<AdvertiserEntity> __updateAdapterOfAdvertiserEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public AdvertiserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAdvertiserEntity = new EntityInsertionAdapter<AdvertiserEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `advertiser` (`advertiserId`,`name`,`companyName`,`avatarFileId`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AdvertiserEntity value) {
                if (value.getAdvertiserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getAdvertiserId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getCompanyName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getCompanyName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAvatarFileId());
                }
                String _tmp = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfAdvertiserEntity = new EntityDeletionOrUpdateAdapter<AdvertiserEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `advertiser` WHERE `advertiserId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AdvertiserEntity value) {
                if (value.getAdvertiserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getAdvertiserId());
                }
            }
        };
        this.__updateAdapterOfAdvertiserEntity = new EntityDeletionOrUpdateAdapter<AdvertiserEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `advertiser` SET `advertiserId` = ?,`name` = ?,`companyName` = ?,`avatarFileId` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `advertiserId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AdvertiserEntity value) {
                if (value.getAdvertiserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getAdvertiserId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getCompanyName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getCompanyName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAvatarFileId());
                }
                String _tmp = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = AdvertiserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                if (value.getAdvertiserId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getAdvertiserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from advertiser";
                return "DELETE from advertiser";
            }
        };
    }

    @Override
    public void insertImpl(AdvertiserEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfAdvertiserEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends AdvertiserEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfAdvertiserEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(AdvertiserEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfAdvertiserEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends AdvertiserEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfAdvertiserEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(AdvertiserEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfAdvertiserEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(AdvertiserEntity object) {
        this.__db.beginTransaction();
        try {
            AdvertiserDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends AdvertiserEntity> objects) {
        this.__db.beginTransaction();
        try {
            AdvertiserDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(AdvertiserEntity object) {
        this.__db.beginTransaction();
        try {
            AdvertiserDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Single<List<AdvertiserEntity>> getByIdImpl(String advertiserId) {
        String _sql = "SELECT * from advertiser where advertiser.advertiserId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from advertiser where advertiser.advertiserId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (advertiserId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, advertiserId);
        }
        return RxRoom.createSingle((Callable)new Callable<List<AdvertiserEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AdvertiserEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AdvertiserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfAdvertiserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"advertiserId");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfCompanyName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"companyName");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<AdvertiserEntity> _result = new ArrayList<AdvertiserEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpAdvertiserId = _cursor.isNull(_cursorIndexOfAdvertiserId) ? null : _cursor.getString(_cursorIndexOfAdvertiserId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpCompanyName = _cursor.isNull(_cursorIndexOfCompanyName) ? null : _cursor.getString(_cursorIndexOfCompanyName);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        AdvertiserEntity _item = new AdvertiserEntity(_tmpAdvertiserId, _tmpName, _tmpCompanyName, _tmpAvatarFileId);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = AdvertiserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = AdvertiserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = AdvertiserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item);
                    }
                    if (_result == null) {
                        throw new EmptyResultSetException("Query returned empty result set: " + _statement.getSql());
                    }
                    ArrayList<AdvertiserEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdvertiserEntity getByIdNowImpl(String advertiserId) {
        String _sql = "SELECT * from advertiser where advertiser.advertiserId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from advertiser where advertiser.advertiserId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (advertiserId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, advertiserId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            AdvertiserEntity _result;
            int _cursorIndexOfAdvertiserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"advertiserId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfCompanyName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"companyName");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpAdvertiserId = _cursor.isNull(_cursorIndexOfAdvertiserId) ? null : _cursor.getString(_cursorIndexOfAdvertiserId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpCompanyName = _cursor.isNull(_cursorIndexOfCompanyName) ? null : _cursor.getString(_cursorIndexOfCompanyName);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _result = new AdvertiserEntity(_tmpAdvertiserId, _tmpName, _tmpCompanyName, _tmpAvatarFileId);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            AdvertiserEntity advertiserEntity = _result;
            return advertiserEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AdvertiserEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from advertiser where advertiser.advertiserId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfAdvertiserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"advertiserId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfCompanyName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"companyName");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<AdvertiserEntity> _result = new ArrayList<AdvertiserEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpAdvertiserId = _cursor.isNull(_cursorIndexOfAdvertiserId) ? null : _cursor.getString(_cursorIndexOfAdvertiserId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpCompanyName = _cursor.isNull(_cursorIndexOfCompanyName) ? null : _cursor.getString(_cursorIndexOfCompanyName);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                AdvertiserEntity _item_1 = new AdvertiserEntity(_tmpAdvertiserId, _tmpName, _tmpCompanyName, _tmpAvatarFileId);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<AdvertiserEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

