package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Insert
import androidx.room.OnConflictStrategy
import com.ekoapp.ekosdk.TaggedEkoObject
import com.ekoapp.ekosdk.internal.data.model.EkoTagObject
import com.ekoapp.ekosdk.internal.data.model.EkoTagObject.EkoTagFactory
import com.google.common.collect.FluentIterable

abstract class EkoTagDao<EntityType : EkoTagObject> {
	@Insert(onConflict = OnConflictStrategy.REPLACE)
	abstract fun insert(objects: List<EntityType>)
	abstract fun retainAll(id: String, tags: Array<String>)
	
	companion object {
		@JvmStatic
		fun <TaggedObject : TaggedEkoObject, TagObject : EkoTagObject> update(ekoObjects: List<TaggedObject>, dao: EkoTagDao<TagObject>, factory: EkoTagFactory<TagObject>) {
			for (ekoObject in ekoObjects) {
				update(ekoObject, dao, factory)
			}
		}
		
		@JvmStatic
        fun <TagObject : EkoTagObject> update(ekoObject: TaggedEkoObject, dao: EkoTagDao<TagObject>, factory: EkoTagFactory<TagObject>) {
			val tags = ekoObject.getTags().toTypedArray()
			val list: List<TagObject> = FluentIterable.from(tags)
					.transform { tag ->
						tag?.let { factory.create(ekoObject.getId(), it) }
					}
					.toList()
			dao.insert(list)
			dao.retainAll(ekoObject.getId(), tags)
		}
	}
}