package com.ekoapp.ekosdk.internal.api.mapper

import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto
import com.ekoapp.ekosdk.internal.entity.CommentEntity

interface EkoCommentMapper : EkoObjectMapper<EkoCommentDto, CommentEntity> {
	override fun update(objectOnDisk: CommentEntity, objectToSave: CommentEntity): CommentEntity {
		return if (objectToSave.updatedAt.isAfter(objectOnDisk.updatedAt)
				|| objectToSave.updatedAt.isEqual(objectOnDisk.updatedAt)) {
			objectToSave
		} else objectOnDisk
	}
	
	companion object {
		val MAPPER: EkoCommentMapper = object: EkoCommentMapper {
			override fun map(dto: EkoCommentDto): CommentEntity {
				val comment = CommentEntity()
				comment.commentId = dto.commentId
				comment.path = dto.path
				comment.referenceType = dto.referenceType
				comment.referenceId = dto.referenceId
				comment.userId = dto.userId
				comment.parentId = dto.parentId
				comment.rootId = dto.rootId
				comment.dataType = dto.dataType
				comment.dataTypes = dto.dataTypes
				comment.data = dto.getData()
				comment.attachments = dto.attachments
				comment.metadata = dto.getMetadata()
				comment.childrenNumber = dto.childrenNumber
				comment.flagCount = dto.flagCount
				comment.reactionCount = dto.reactionCount
				comment.reactions = dto.reactions
				comment.isDeleted = dto.deleted
				comment.editedAt = dto.editedAt
				comment.createdAt = dto.createdAt
				comment.updatedAt = dto.updatedAt
				comment.segmentNumber = dto.segmentNumber
				if (dto.mentionees != null) {
					comment.mentionees = dto.mentionees
				}
				return comment
			}
		}
	}
}