package com.ekoapp.ekosdk.internal

import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity
import com.ekoapp.ekosdk.internal.entity.CommunityEntity

enum class TombstoneModelType(val entityName: String) {

    USER(UserEntity::class.java.simpleName),
    MESSAGE(EkoMessageEntity::class.java.simpleName),
    POST(PostEntity::class.java.simpleName),
    CHANNEL(EkoChannelEntity::class.java.simpleName),
    COMMUNITY(CommunityEntity::class.java.simpleName),
    CATEGORY(CommunityCategoryEntity::class.java.simpleName),
    FOLLOW_COUNT(EkoFollowCountEntity::class.java.simpleName),
    SUB_CHANNEL(SubChannelEntity::class.java.simpleName),
    STORY(StoryEntity::class.java.simpleName),
    STORY_TARGET(StoryTargetEntity::class.java.simpleName),
    UNKNOWN(EkoObject::class.java.simpleName);

    companion object {
        fun enumOf(entityName: String): TombstoneModelType =
            (values().find { it.entityName == entityName } ?: UNKNOWN)
    }
}