package com.amity.socialcloud.sdk.core.data.user.flag

import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag
import io.reactivex.rxjava3.core.Completable

internal class UserFlagLocalDataStore {

    fun saveFlags(flags: List<EkoUserFlag>): Completable {
        return Completable.fromAction {
            val dao = UserDatabase.get().userFlagDao()
            flags.forEach {
                dao.getByIdNow(it.userId)?.let { flag ->
                    it.localFlag = flag.localFlag
                }
            }
            dao.save(flags)
        }
    }
}