package com.amity.socialcloud.sdk.core.data.file

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto
import io.reactivex.rxjava3.core.Single

internal class FileRemoteDataStore {

    fun deleteFile(fileId: String) : Single<String> {
        return AmityHttpClient.get(FileApi::class).flatMap {
            it.deleteFile(fileId)
        }.map {
                it.fileId ?: ""
            }
    }

    fun getFile(fileId: String) : Single<EkoFileDto> {
        return AmityHttpClient.get(FileApi::class).flatMap {
            it.getFile(fileId)
        }
    }

}