/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.ReadReceiptEntity;
import com.ekoapp.ekosdk.internal.data.dao.ReadReceiptDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class ReadReceiptDao_Impl
extends ReadReceiptDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ReadReceiptEntity> __insertionAdapterOfReadReceiptEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<ReadReceiptEntity> __deletionAdapterOfReadReceiptEntity;
    private final EntityDeletionOrUpdateAdapter<ReadReceiptEntity> __updateAdapterOfReadReceiptEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteBySubChannelId;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLatestSegment;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLatestSyncSegment;

    public ReadReceiptDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfReadReceiptEntity = new EntityInsertionAdapter<ReadReceiptEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `read_receipt` (`subChannelId`,`latestSegment`,`latestSyncSegment`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ReadReceiptEntity value) {
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSubChannelId());
                }
                stmt.bindLong(2, (long)value.getLatestSegment());
                stmt.bindLong(3, (long)value.getLatestSyncSegment());
                String _tmp = ReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = ReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = ReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfReadReceiptEntity = new EntityDeletionOrUpdateAdapter<ReadReceiptEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `read_receipt` WHERE `subChannelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ReadReceiptEntity value) {
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSubChannelId());
                }
            }
        };
        this.__updateAdapterOfReadReceiptEntity = new EntityDeletionOrUpdateAdapter<ReadReceiptEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `read_receipt` SET `subChannelId` = ?,`latestSegment` = ?,`latestSyncSegment` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `subChannelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ReadReceiptEntity value) {
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getSubChannelId());
                }
                stmt.bindLong(2, (long)value.getLatestSegment());
                stmt.bindLong(3, (long)value.getLatestSyncSegment());
                String _tmp = ReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = ReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = ReadReceiptDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                if (value.getSubChannelId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getSubChannelId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from read_receipt";
                return "DELETE from read_receipt";
            }
        };
        this.__preparedStmtOfDeleteBySubChannelId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from read_receipt where subChannelId = ?";
                return "DELETE from read_receipt where subChannelId = ?";
            }
        };
        this.__preparedStmtOfUpdateLatestSegment = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE read_receipt set latestSegment = ? where subChannelId = ? and latestSegment < ?";
                return "UPDATE read_receipt set latestSegment = ? where subChannelId = ? and latestSegment < ?";
            }
        };
        this.__preparedStmtOfUpdateLatestSyncSegment = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE read_receipt set latestSyncSegment = ? where subChannelId = ? and latestSyncSegment < ?";
                return "UPDATE read_receipt set latestSyncSegment = ? where subChannelId = ? and latestSyncSegment < ?";
            }
        };
    }

    @Override
    public void insertImpl(ReadReceiptEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfReadReceiptEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends ReadReceiptEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfReadReceiptEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ReadReceiptEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfReadReceiptEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends ReadReceiptEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfReadReceiptEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(ReadReceiptEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfReadReceiptEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(ReadReceiptEntity object) {
        this.__db.beginTransaction();
        try {
            ReadReceiptDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends ReadReceiptEntity> objects) {
        this.__db.beginTransaction();
        try {
            ReadReceiptDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ReadReceiptEntity object) {
        this.__db.beginTransaction();
        try {
            ReadReceiptDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBySubChannelId(String subChannelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteBySubChannelId.acquire();
        int _argIndex = 1;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteBySubChannelId.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLatestSegment(String subChannelId, int segment) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLatestSegment.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)segment);
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)segment);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLatestSegment.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLatestSyncSegment(String subChannelId, int segment) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLatestSyncSegment.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)segment);
        _argIndex = 2;
        if (subChannelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subChannelId);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)segment);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLatestSyncSegment.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadReceiptEntity getByIdNow(String subChannelId) {
        String _sql = "SELECT * from read_receipt where subChannelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from read_receipt where subChannelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ReadReceiptEntity _result;
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfLatestSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSegment");
            int _cursorIndexOfLatestSyncSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSyncSegment");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new ReadReceiptEntity();
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _result.setSubChannelId(_tmpSubChannelId);
                int _tmpLatestSegment = _cursor.getInt(_cursorIndexOfLatestSegment);
                _result.setLatestSegment(_tmpLatestSegment);
                int _tmpLatestSyncSegment = _cursor.getInt(_cursorIndexOfLatestSyncSegment);
                _result.setLatestSyncSegment(_tmpLatestSyncSegment);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            ReadReceiptEntity readReceiptEntity = _result;
            return readReceiptEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<ReadReceiptEntity> getById(String subChannelId) {
        String _sql = "SELECT * from read_receipt where subChannelId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from read_receipt where subChannelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (subChannelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subChannelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"read_receipt"}, (Callable)new Callable<ReadReceiptEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReadReceiptEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ReadReceiptDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ReadReceiptEntity _result;
                    int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
                    int _cursorIndexOfLatestSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSegment");
                    int _cursorIndexOfLatestSyncSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSyncSegment");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new ReadReceiptEntity();
                        String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                        _result.setSubChannelId(_tmpSubChannelId);
                        int _tmpLatestSegment = _cursor.getInt(_cursorIndexOfLatestSegment);
                        _result.setLatestSegment(_tmpLatestSegment);
                        int _tmpLatestSyncSegment = _cursor.getInt(_cursorIndexOfLatestSyncSegment);
                        _result.setLatestSyncSegment(_tmpLatestSyncSegment);
                        String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = ReadReceiptDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = ReadReceiptDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = ReadReceiptDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    ReadReceiptEntity readReceiptEntity = _result;
                    return readReceiptEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReadReceiptEntity> getUnsyncReadReceipts() {
        String _sql = "SELECT * from read_receipt where latestSyncSegment < latestSegment";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from read_receipt where latestSyncSegment < latestSegment", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfSubChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subChannelId");
            int _cursorIndexOfLatestSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSegment");
            int _cursorIndexOfLatestSyncSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestSyncSegment");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<ReadReceiptEntity> _result = new ArrayList<ReadReceiptEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ReadReceiptEntity _item = new ReadReceiptEntity();
                String _tmpSubChannelId = _cursor.isNull(_cursorIndexOfSubChannelId) ? null : _cursor.getString(_cursorIndexOfSubChannelId);
                _item.setSubChannelId(_tmpSubChannelId);
                int _tmpLatestSegment = _cursor.getInt(_cursorIndexOfLatestSegment);
                _item.setLatestSegment(_tmpLatestSegment);
                int _tmpLatestSyncSegment = _cursor.getInt(_cursorIndexOfLatestSyncSegment);
                _item.setLatestSyncSegment(_tmpLatestSyncSegment);
                String _tmp = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item.setExpiresAt(_tmpExpiresAt);
                _result.add(_item);
            }
            ArrayList<ReadReceiptEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

