package com.amity.socialcloud.sdk.model.chat.subchannel

import android.os.Parcelable
import com.amity.socialcloud.sdk.api.core.events.AmityTopicSubscription
import com.amity.socialcloud.sdk.chat.domain.marker.channel.CheckMarkerServiceSupportedUseCase
import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.message.AmityMessagePreview
import com.amity.socialcloud.sdk.model.core.events.AmityTopic
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmitySubChannel internal constructor(
    private val subChannelId: String,
    private val channelId: String,
    private val channelType: AmityChannel.Type?,
    private val channelPublicId: String,
    private val displayName: String,
    private val messageCount: Int,
    private val isDeleted: Boolean,
    private val latestMessageId: String,
    private val lastActivity: DateTime,
    private val creatorId: String,
    private val creatorPublicId: String,
    internal var creator: AmityUser?,
    private val editedAt: DateTime,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
    internal val path: String,
    private val messagePreviewId: String? = null,
    internal var messagePreview: AmityMessagePreview? = null,
    internal var unreadCount: Int = 0,
    internal var hasMentioned: Boolean = false,
    internal var isMentioned: Boolean = false,
) : Parcelable, ReactorObject {

    fun getSubChannelId(): String {
        return subChannelId
    }

    fun getChannelId(): String {
        return channelPublicId
    }

    fun getDisplayName(): String {
        return displayName
    }

    fun getMessageCount(): Int {
        return messageCount
    }

    fun isDeleted(): Boolean {
        return isDeleted
    }

    fun getLatestMessageId(): String {
        return latestMessageId
    }

    fun getLastActivity(): DateTime {
        return lastActivity
    }

    fun getCreatorId(): String {
        return creatorPublicId
    }

    fun getCreator(): AmityUser? {
        return creator
    }

    fun getEditedAt(): DateTime {
        return editedAt
    }
    
    fun getUnreadCount(): Int {
        return unreadCount
    }

    @Deprecated("Use isMentioned() instead", ReplaceWith("isMentioned"))
    fun hasMentioned(): Boolean {
        return hasMentioned
    }
    
    fun isMentioned(): Boolean {
        return isMentioned
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    override fun updatedAt(): DateTime {
        return updatedAt
    }

    override fun uniqueId(): String {
        return subChannelId
    }

    fun subscription(): AmityTopicSubscription {
        return AmityTopicSubscription(AmityTopic.SUB_CHANNEL(this))
    }
    
    @Deprecated("Use SubChannelRepository.startMessageReceiptSync instead")
    /* begin_public_function
	  id: channel.start_reading
	*/
    fun startReading(): Completable {
        return CoreClient.startReading(subChannelId, channelId)
    }
    /* end_public_function */
    
    
    @Deprecated("Use SubChannelRepository.stopMessageReceiptSync instead")
    /* begin_public_function
	  id: channel.stop_reading
	*/
    fun stopReading(): Completable {
        return CoreClient.stopReading(subChannelId, channelId)
    }
    /* end_public_function */
    
    fun isUnreadCountSupport(): Boolean {
        return CheckMarkerServiceSupportedUseCase().execute(channelType)
    }
    
    fun getMessagePreviewId(): String? {
        return messagePreviewId
    }
    
    fun getMessagePreview(): AmityMessagePreview? {
        return messagePreview
    }
}