package com.amity.socialcloud.sdk.core.data.analytics.paging

import com.amity.socialcloud.sdk.model.core.analytics.AmityViewedType
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

internal class ViewedUsersKeyCreator(
    private val viewableItemType: AmityViewedType,
    private val viewableItemId: String
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "viewableItemType" to viewableItemType.apiKey,
            "viewableItemId" to viewableItemId
        )
    }

    override fun getFilterQuery(): String {
        return " true"
    }

}