package com.amity.socialcloud.sdk.chat.data.marker.subchannel

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.SubChannelMarkerEntity
import com.ekoapp.ekosdk.internal.api.dto.SubChannelMarkerDto
import org.joda.time.DateTime

internal class SubChannelMarkerEntityMapper : EntityMapper<SubChannelMarkerDto, SubChannelMarkerEntity>() {

    override fun map(list: List<SubChannelMarkerDto>): List<SubChannelMarkerEntity> {
        return list.map { map(it) }
    }

    fun map(dto: SubChannelMarkerDto) : SubChannelMarkerEntity {
        return SubChannelMarkerEntity().apply {
            subChannelId = dto.subChannelId
            channelId = dto.channelId
            lastSegment = dto.lastSegment
            createdAt = dto.createdAt ?: DateTime.now()
            updatedAt = dto.updatedAt ?: DateTime.now()
        }
    }

}