package com.amity.socialcloud.sdk.api.social.comment.query

import com.amity.socialcloud.sdk.model.social.comment.AmityComment

sealed class AmityCommentDataTypeFilter {

    abstract val dataTypes: List<AmityComment.DataType>
    abstract val matchType: String

    data class Any(
        override val dataTypes: List<AmityComment.DataType>,
        override val matchType: String = "any"
    ) : AmityCommentDataTypeFilter()

    data class Exact(
        override val dataTypes: List<AmityComment.DataType>,
        override val matchType: String = "exact"
    ) : AmityCommentDataTypeFilter()
}