package com.amity.socialcloud.sdk.api.core.endpoint

const val SG_HTTP_ENDPOINT = "https://apix.sg.amity.co/"
const val EU_HTTP_ENDPOINT = "https://apix.eu.amity.co/"
const val US_HTTP_ENDPOINT = "https://apix.us.amity.co/"

const val SG_SOCKET_ENDPOINT = "https://api.sg.amity.co/"
const val EU_SOCKET_ENDPOINT = "https://api.eu.amity.co/"
const val US_SOCKET_ENDPOINT = "https://api.us.amity.co/"

const val SG_MQTT_ENDPOINT = "ssq.sg.amity.co"
const val EU_MQTT_ENDPOINT = "ssq.eu.amity.co"
const val US_MQTT_ENDPOINT = "ssq.us.amity.co"

const val SG_UPLOAD_ENDPOINT = "https://upload.sg.amity.co/"
const val EU_UPLOAD_ENDPOINT = "https://upload.eu.amity.co/"
const val US_UPLOAD_ENDPOINT = "https://upload.us.amity.co/"

sealed class AmityEndpoint(
    val httpEndpoint: String,
    val socketEndpoint: String,
    val mqttEndpoint: String,
    val uploadEndpoint: String
) {

    object SG :
        AmityEndpoint(SG_HTTP_ENDPOINT, SG_SOCKET_ENDPOINT, SG_MQTT_ENDPOINT, SG_UPLOAD_ENDPOINT)

    object EU :
        AmityEndpoint(EU_HTTP_ENDPOINT, EU_SOCKET_ENDPOINT, EU_MQTT_ENDPOINT, EU_UPLOAD_ENDPOINT)

    object US :
        AmityEndpoint(US_HTTP_ENDPOINT, US_SOCKET_ENDPOINT, US_MQTT_ENDPOINT, US_UPLOAD_ENDPOINT)

    class CUSTOM(
        httpEndpoint: String,
        socketEndpoint: String,
        mqttEndpoint: String,
        uploadEndpoint: String = when(httpEndpoint) {
            SG_HTTP_ENDPOINT -> SG_UPLOAD_ENDPOINT
            EU_HTTP_ENDPOINT -> EU_UPLOAD_ENDPOINT
            US_HTTP_ENDPOINT -> US_UPLOAD_ENDPOINT
            else -> SG_UPLOAD_ENDPOINT
        }
    ) : AmityEndpoint(httpEndpoint, socketEndpoint, mqttEndpoint, uploadEndpoint)

}