package com.amity.socialcloud.sdk.chat.data.marker.channel

import com.amity.socialcloud.sdk.model.core.unread.UserUnread
import com.ekoapp.ekosdk.internal.ChannelMarkerEntity
import com.ekoapp.ekosdk.internal.ChannelUnreadInfoEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

internal class ChannelMarkerLocalDataStore {
    
    fun getChannelMarker(channelId: String): ChannelMarkerEntity? {
        return UserDatabase.get().channelMarkerDao().getByIdNow(channelId)
    }
    
    fun saveChannelMarkers(
        channelMarkers: List<ChannelMarkerEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().channelMarkerDao().save(channelMarkers)
        }
    }
    
    fun getChannelUnreadInfo(channelId: String): ChannelUnreadInfoEntity? {
        return UserDatabase.get().channelUnreadInfoDao().getByChannelIdNow(channelId)
    }
    
    fun saveChannelUnreadInfo(
        channelUnreadInfos: List<ChannelUnreadInfoEntity>,
    ) {
        UserDatabase.get().channelUnreadInfoDao().save(channelUnreadInfos)
    }
    
    fun getTotalChannelsUnreadInfo(): Flowable<UserUnread> {
        return UserDatabase.get().channelUnreadInfoDao().getTotalChannelsUnreadInfo()
            .map {
                UserUnread(it.unreadCount, it.isMentioned, it.isMentioned)
            }
    }

}