package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import androidx.sqlite.db.SupportSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.chat.data.channel.singlepage.ChannelListKeyCreator
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.EkoChannelEntity
import com.ekoapp.ekosdk.internal.PostEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.keycreator.GlobalFeedKeyCreator
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagingDao
import com.ekoapp.ekosdk.internal.paging.SinglePagePagerCreator
import io.reactivex.rxjava3.core.Flowable

@Dao
internal interface AmityChannelListPagingDao : QueryStreamPagingDao<EkoChannelEntity> {
    @RawQuery(observedEntities = [EkoChannelEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, EkoChannelEntity>
    
    @RawQuery(observedEntities = [EkoChannelEntity::class, AmityPagingId::class])
    fun getChannelByIdsImpl(query: SimpleSQLiteQuery): Flowable<List<EkoChannelEntity>>

    fun getChannels(channelIds: List<String>): Flowable<List<EkoChannelEntity>> {
        val keyCreator = ChannelListKeyCreator(channelIds = channelIds)
        val query =  generateQueryStreamSQL(
                tableName = "channel",
                primaryKeyColumnName = "channelId",
                queryStreamKeyCreator = keyCreator,
                nonce = AmityNonce.CHANNEL_LIST,
                order = AmityPagingDao.Order.ASC
        )
        return getChannelByIdsImpl(query)
    }
}