package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.socket.util.EkoGson.get
import com.ekoapp.ekosdk.internal.EkoLocalFlag

class EkoLocalFlagTypeConverter {
	@TypeConverter
	fun stringToEkoLocalFlag(json: String?): EkoLocalFlag? {
		return json?.let{ get().fromJson(it, EkoLocalFlag::class.java) }
	}
	
	@TypeConverter
	fun ekoLocalFlagToString(flag: EkoLocalFlag?): String? {
		return flag?.let(get()::toJson)
	}
}