package com.amity.socialcloud.sdk.social.data.story

import com.amity.socialcloud.sdk.dto.social.story.CreateStoryRequest
import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.DELETE
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Path
import retrofit2.http.Query
import retrofit2.http.QueryMap

interface StoryApi {

    @POST("api/v4/stories")
    fun createStory(
        @Body request: CreateStoryRequest
    ): Single<StoryQueryDto>

    @GET("api/v4/stories")
    fun queryStories(
        @Query("targetType") targetType: String? = null,
        @Query("targetId") targetId: String? = null,
        @Query("options[sortBy]", encoded = true) sortBy: String? = null,
        @Query("options[orderBy]", encoded = true) orderBy: String? = null
    ): Single<StoryQueryDto>

    @GET("api/v4/stories/{storyId}")
    fun getStory(
        @Path("storyId") storyId: String,
    ): Single<StoryQueryDto>


    @DELETE("api/v4/stories/{storyId}")
    fun deleteStory(
        @Path("storyId") storyId: String,
        @Query("permanent") permanent: Boolean
    ): Single<EkoDeletionDto>

    @GET("api/v4/stories-by-targets")
    fun queryStoriesByTargets(
        @QueryMap targets: Map<String, String>,
        @Query("options[sortBy]", encoded = true) sortBy: String? = null,
        @Query("options[orderBy]", encoded = true) orderBy: String? = null
    ): Single<StoryQueryDto>

}