/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.session.transformer;

import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/amity/socialcloud/sdk/core/session/transformer/SessionStateTransformer;", "", "()V", "transform", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "currentSessionState", "appEvent", "Lcom/amity/socialcloud/sdk/core/session/model/AppEvent;", "amity-sdk_release"})
public final class SessionStateTransformer {
    @NotNull
    public static final SessionStateTransformer INSTANCE = new SessionStateTransformer();

    private SessionStateTransformer() {
    }

    @Nullable
    public final SessionState transform(@NotNull SessionState currentSessionState, @NotNull AppEvent appEvent) {
        Intrinsics.checkNotNullParameter((Object)currentSessionState, (String)"currentSessionState");
        Intrinsics.checkNotNullParameter((Object)appEvent, (String)"appEvent");
        AppEvent appEvent2 = appEvent;
        if (appEvent2 instanceof AppEvent.AppLaunchWithUser) {
            if (Intrinsics.areEqual((Object)currentSessionState, (Object)SessionState.NotLoggedIn.INSTANCE)) {
                return SessionState.Established.INSTANCE;
            }
        } else {
            if (appEvent2 instanceof AppEvent.AppLaunchWithoutUser) {
                return SessionState.NotLoggedIn.INSTANCE;
            }
            if (appEvent2 instanceof AppEvent.LoggingIn) {
                if (Intrinsics.areEqual((Object)currentSessionState, (Object)SessionState.NotLoggedIn.INSTANCE) || Intrinsics.areEqual((Object)currentSessionState, (Object)SessionState.Established.INSTANCE) || currentSessionState instanceof SessionState.Terminated) {
                    return SessionState.Establishing.INSTANCE;
                }
            } else if (appEvent2 instanceof AppEvent.LoginSuccess) {
                if (Intrinsics.areEqual((Object)currentSessionState, (Object)SessionState.Establishing.INSTANCE)) {
                    return SessionState.Established.INSTANCE;
                }
            } else if (appEvent2 instanceof AppEvent.LoginFail) {
                if (Intrinsics.areEqual((Object)currentSessionState, (Object)SessionState.Establishing.INSTANCE)) {
                    return SessionState.NotLoggedIn.INSTANCE;
                }
            } else {
                if (appEvent2 instanceof AppEvent.ManualLogout) {
                    return SessionState.NotLoggedIn.INSTANCE;
                }
                if (appEvent2 instanceof AppEvent.TokenRenewSuccess) {
                    if (Intrinsics.areEqual((Object)currentSessionState, (Object)SessionState.TokenExpired.INSTANCE)) {
                        return SessionState.Established.INSTANCE;
                    }
                } else if (appEvent2 instanceof AppEvent.TerminationCodeReceive) {
                    if (Intrinsics.areEqual((Object)currentSessionState, (Object)SessionState.Established.INSTANCE) || Intrinsics.areEqual((Object)currentSessionState, (Object)SessionState.TokenExpired.INSTANCE)) {
                        return new SessionState.Terminated(((AppEvent.TerminationCodeReceive)appEvent).getError());
                    }
                } else {
                    if (appEvent2 instanceof AppEvent.TokenExpire) {
                        return SessionState.TokenExpired.INSTANCE;
                    }
                    return null;
                }
            }
        }
        return null;
    }
}

