package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoFcmToken;

import io.reactivex.rxjava3.core.Flowable;

@Dao
public abstract class EkoFcmTokenDao {

    @Query("SELECT * from fcm_token LIMIT 1")
    public abstract Flowable<EkoFcmToken> getFcmToken();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insert(EkoFcmToken fcmToken);
}
