package com.amity.socialcloud.sdk.core.data.presence.user

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.UserPresenceDto
import com.ekoapp.ekosdk.internal.entity.UserPresenceEntity

internal class UserPresenceEntityMapper : EntityMapper<UserPresenceDto, UserPresenceEntity>() {

    override fun map(list: List<UserPresenceDto>): List<UserPresenceEntity> {
        return list.map {
            UserPresenceEntity(
                userId = it.userId ?: "",
                lastHeartbeat = it.lastHeartbeat
            )
        }
    }
}