/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.MentioneesConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoCommentDao_Impl
extends EkoCommentDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CommentEntity> __insertionAdapterOfCommentEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final MentioneesConverter __mentioneesConverter = new MentioneesConverter();
    private final EntityDeletionOrUpdateAdapter<CommentEntity> __deletionAdapterOfCommentEntity;
    private final EntityDeletionOrUpdateAdapter<CommentEntity> __updateAdapterOfCommentEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfInitSyncStateOnStartup;
    private final SharedSQLiteStatement __preparedStmtOfSoftDeleteById;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByReferenceId;
    private final SharedSQLiteStatement __preparedStmtOfUpdateComment;
    private final SharedSQLiteStatement __preparedStmtOfMarkAllDeletedBeforeCreatedAt;
    private final SharedSQLiteStatement __preparedStmtOfMarkAllDeletedAfterCreatedAt;

    public EkoCommentDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommentEntity = new EntityInsertionAdapter<CommentEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `comment` (`commentId`,`path`,`referenceType`,`referenceId`,`userId`,`parentId`,`rootId`,`dataType`,`dataTypes`,`data`,`attachments`,`metadata`,`childrenNumber`,`flagCount`,`reactions`,`reactionCount`,`isDeleted`,`editedAt`,`syncState`,`segmentNumber`,`mentionees`,`targetType`,`targetId`,`myReactions`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommentEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPath());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReferenceId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUserId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getParentId());
                }
                if (value.getRootId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getRootId());
                }
                if (value.getDataType() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getDataType());
                }
                String _tmp = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(value.getDataTypes());
                if (_tmp == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp);
                }
                String _tmp_1 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_1 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_1);
                }
                String _tmp_2 = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(value.getAttachments());
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_2);
                }
                String _tmp_3 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_3 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_3);
                }
                stmt.bindLong(13, (long)value.getChildrenNumber());
                stmt.bindLong(14, (long)value.getFlagCount());
                String _tmp_4 = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_4 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_4);
                }
                stmt.bindLong(16, (long)value.getReactionCount());
                int _tmp_5 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp_5);
                String _tmp_6 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getSyncState());
                }
                stmt.bindLong(20, (long)value.getSegmentNumber());
                String _tmp_7 = EkoCommentDao_Impl.this.__mentioneesConverter.mentioneesToJson(value.getMentionees());
                if (_tmp_7 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_7);
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, value.getTargetId());
                }
                String _tmp_8 = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(value.getMyReactions());
                if (_tmp_8 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_8);
                }
                String _tmp_9 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, _tmp_9);
                }
                String _tmp_10 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_10 == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindString(26, _tmp_10);
                }
                String _tmp_11 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_11 == null) {
                    stmt.bindNull(27);
                } else {
                    stmt.bindString(27, _tmp_11);
                }
            }
        };
        this.__deletionAdapterOfCommentEntity = new EntityDeletionOrUpdateAdapter<CommentEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `comment` WHERE `commentId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommentEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
            }
        };
        this.__updateAdapterOfCommentEntity = new EntityDeletionOrUpdateAdapter<CommentEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `comment` SET `commentId` = ?,`path` = ?,`referenceType` = ?,`referenceId` = ?,`userId` = ?,`parentId` = ?,`rootId` = ?,`dataType` = ?,`dataTypes` = ?,`data` = ?,`attachments` = ?,`metadata` = ?,`childrenNumber` = ?,`flagCount` = ?,`reactions` = ?,`reactionCount` = ?,`isDeleted` = ?,`editedAt` = ?,`syncState` = ?,`segmentNumber` = ?,`mentionees` = ?,`targetType` = ?,`targetId` = ?,`myReactions` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `commentId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommentEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPath());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReferenceId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUserId());
                }
                if (value.getParentId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getParentId());
                }
                if (value.getRootId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getRootId());
                }
                if (value.getDataType() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getDataType());
                }
                String _tmp = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(value.getDataTypes());
                if (_tmp == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp);
                }
                String _tmp_1 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp_1 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_1);
                }
                String _tmp_2 = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(value.getAttachments());
                if (_tmp_2 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_2);
                }
                String _tmp_3 = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_3 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_3);
                }
                stmt.bindLong(13, (long)value.getChildrenNumber());
                stmt.bindLong(14, (long)value.getFlagCount());
                String _tmp_4 = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_4 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_4);
                }
                stmt.bindLong(16, (long)value.getReactionCount());
                int _tmp_5 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp_5);
                String _tmp_6 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_6);
                }
                if (value.getSyncState() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getSyncState());
                }
                stmt.bindLong(20, (long)value.getSegmentNumber());
                String _tmp_7 = EkoCommentDao_Impl.this.__mentioneesConverter.mentioneesToJson(value.getMentionees());
                if (_tmp_7 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_7);
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, value.getTargetId());
                }
                String _tmp_8 = EkoCommentDao_Impl.this.__stringListConverter.stringListToString(value.getMyReactions());
                if (_tmp_8 == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, _tmp_8);
                }
                String _tmp_9 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindString(25, _tmp_9);
                }
                String _tmp_10 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_10 == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindString(26, _tmp_10);
                }
                String _tmp_11 = EkoCommentDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_11 == null) {
                    stmt.bindNull(27);
                } else {
                    stmt.bindString(27, _tmp_11);
                }
                if (value.getCommentId() == null) {
                    stmt.bindNull(28);
                } else {
                    stmt.bindString(28, value.getCommentId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from comment";
                return "DELETE from comment";
            }
        };
        this.__preparedStmtOfInitSyncStateOnStartup = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set syncState = 'failed' where syncState = 'syncing'";
                return "UPDATE comment set syncState = 'failed' where syncState = 'syncing'";
            }
        };
        this.__preparedStmtOfSoftDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set isDeleted = 1 where commentId = ?";
                return "UPDATE comment set isDeleted = 1 where commentId = ?";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from comment where commentId = ?";
                return "DELETE from comment where commentId = ?";
            }
        };
        this.__preparedStmtOfDeleteByReferenceId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from comment where referenceId = ?";
                return "DELETE from comment where referenceId = ?";
            }
        };
        this.__preparedStmtOfUpdateComment = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set commentId = commentId where commentId = ?";
                return "UPDATE comment set commentId = commentId where commentId = ?";
            }
        };
        this.__preparedStmtOfMarkAllDeletedBeforeCreatedAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set isDeleted = 1 where createdAt < ?";
                return "UPDATE comment set isDeleted = 1 where createdAt < ?";
            }
        };
        this.__preparedStmtOfMarkAllDeletedAfterCreatedAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE comment set isDeleted = 1 where createdAt > ?";
                return "UPDATE comment set isDeleted = 1 where createdAt > ?";
            }
        };
    }

    @Override
    public void insertImpl(CommentEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommentEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends CommentEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommentEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(CommentEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommentEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends CommentEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommentEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(CommentEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCommentEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(CommentEntity object) {
        this.__db.beginTransaction();
        try {
            EkoCommentDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends CommentEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoCommentDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(CommentEntity object) {
        this.__db.beginTransaction();
        try {
            EkoCommentDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public void initSyncStateOnStartup() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfInitSyncStateOnStartup.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfInitSyncStateOnStartup.release(_stmt);
        }
    }

    @Override
    public Completable softDeleteById(final String commentId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = EkoCommentDao_Impl.this.__preparedStmtOfSoftDeleteById.acquire();
                int _argIndex = 1;
                if (commentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, commentId);
                }
                EkoCommentDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EkoCommentDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoCommentDao_Impl.this.__db.endTransaction();
                    EkoCommentDao_Impl.this.__preparedStmtOfSoftDeleteById.release(_stmt);
                }
            }
        });
    }

    @Override
    public Completable deleteById(final String commentId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = EkoCommentDao_Impl.this.__preparedStmtOfDeleteById.acquire();
                int _argIndex = 1;
                if (commentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, commentId);
                }
                EkoCommentDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EkoCommentDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoCommentDao_Impl.this.__db.endTransaction();
                    EkoCommentDao_Impl.this.__preparedStmtOfDeleteById.release(_stmt);
                }
            }
        });
    }

    @Override
    public Completable deleteByReferenceId(final String referenceId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = EkoCommentDao_Impl.this.__preparedStmtOfDeleteByReferenceId.acquire();
                int _argIndex = 1;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, referenceId);
                }
                EkoCommentDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EkoCommentDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EkoCommentDao_Impl.this.__db.endTransaction();
                    EkoCommentDao_Impl.this.__preparedStmtOfDeleteByReferenceId.release(_stmt);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateComment(String commentId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateComment.acquire();
        int _argIndex = 1;
        if (commentId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, commentId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateComment.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAllDeletedBeforeCreatedAt(DateTime createdAt) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfMarkAllDeletedBeforeCreatedAt.acquire();
        int _argIndex = 1;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfMarkAllDeletedBeforeCreatedAt.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAllDeletedAfterCreatedAt(DateTime createdAt) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfMarkAllDeletedAfterCreatedAt.acquire();
        int _argIndex = 1;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(createdAt);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfMarkAllDeletedAfterCreatedAt.release(_stmt);
        }
    }

    @Override
    DataSource.Factory<Integer, CommentEntity> getAllImpl(String referenceType, String referenceId, Boolean isDeleted, Boolean isSortByCreatedACS) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ?  and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ?  and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)6);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 5;
        Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 6;
        Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, CommentEntity>(){

            public LimitOffsetDataSource<CommentEntity> create() {
                return new LimitOffsetDataSource<CommentEntity>(EkoCommentDao_Impl.this.__db, _statement, false, true, new String[]{"comment", "comment_flag"}){

                    protected List<CommentEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentId");
                        int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"path");
                        int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceType");
                        int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceId");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parentId");
                        int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"rootId");
                        int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dataType");
                        int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dataTypes");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"data");
                        int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"attachments");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childrenNumber");
                        int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                        int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactions");
                        int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionCount");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"editedAt");
                        int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"syncState");
                        int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"segmentNumber");
                        int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"mentionees");
                        int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetType");
                        int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetId");
                        int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"myReactions");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"expiresAt");
                        ArrayList<CommentEntity> _res = new ArrayList<CommentEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            String _tmpCommentId = cursor.isNull(_cursorIndexOfCommentId) ? null : cursor.getString(_cursorIndexOfCommentId);
                            String _tmpPath = cursor.isNull(_cursorIndexOfPath) ? null : cursor.getString(_cursorIndexOfPath);
                            String _tmpReferenceType = cursor.isNull(_cursorIndexOfReferenceType) ? null : cursor.getString(_cursorIndexOfReferenceType);
                            String _tmpReferenceId = cursor.isNull(_cursorIndexOfReferenceId) ? null : cursor.getString(_cursorIndexOfReferenceId);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            String _tmpParentId = cursor.isNull(_cursorIndexOfParentId) ? null : cursor.getString(_cursorIndexOfParentId);
                            String _tmpRootId = cursor.isNull(_cursorIndexOfRootId) ? null : cursor.getString(_cursorIndexOfRootId);
                            String _tmpDataType = cursor.isNull(_cursorIndexOfDataType) ? null : cursor.getString(_cursorIndexOfDataType);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfDataTypes) ? null : cursor.getString(_cursorIndexOfDataTypes);
                            List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_4);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfData) ? null : cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfAttachments) ? null : cursor.getString(_cursorIndexOfAttachments);
                            JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_6);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                            int _tmpChildrenNumber = cursor.getInt(_cursorIndexOfChildrenNumber);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfReactions) ? null : cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_8);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            int _tmp_9 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_9 != 0;
                            String _tmp_10 = cursor.isNull(_cursorIndexOfEditedAt) ? null : cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            String _tmpSyncState = cursor.isNull(_cursorIndexOfSyncState) ? null : cursor.getString(_cursorIndexOfSyncState);
                            int _tmpSegmentNumber = cursor.getInt(_cursorIndexOfSegmentNumber);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfMentionees) ? null : cursor.getString(_cursorIndexOfMentionees);
                            List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_11);
                            String _tmpTargetType = cursor.isNull(_cursorIndexOfTargetType) ? null : cursor.getString(_cursorIndexOfTargetType);
                            String _tmpTargetId = cursor.isNull(_cursorIndexOfTargetId) ? null : cursor.getString(_cursorIndexOfTargetId);
                            CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                            String _tmp_12 = cursor.isNull(_cursorIndexOfMyReactions) ? null : cursor.getString(_cursorIndexOfMyReactions);
                            List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_12);
                            _item.setMyReactions(_tmpMyReactions);
                            String _tmp_13 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_14 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmp_15 = cursor.isNull(_cursorIndexOfExpiresAt) ? null : cursor.getString(_cursorIndexOfExpiresAt);
                            DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                            _item.setExpiresAt(_tmpExpiresAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    Flowable<List<CommentEntity>> getAllByIdsImpl(List<String> commentIds, Boolean isSortByCreatedACS) {
        Integer _tmp_1;
        Integer _tmp;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT comment.* from comment where comment.commentId in (");
        int _inputSize = commentIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")  order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then comment.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then comment.createdAt end desc");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : commentIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        Integer n = isSortByCreatedACS == null ? null : (_tmp = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2 + _inputSize;
        Integer n2 = isSortByCreatedACS == null ? null : (_tmp_1 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment"}, (Callable)new Callable<List<CommentEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CommentEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                        List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                        JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_6);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        int _tmp_7 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_7 != 0;
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_9);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        CommentEntity _item_1 = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_10);
                        _item_1.setMyReactions(_tmpMyReactions);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _item_1.setCreatedAt(_tmpCreatedAt);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _item_1.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _item_1.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item_1);
                    }
                    ArrayList<CommentEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    DataSource.Factory<Integer, CommentEntity> getAllByParentIdImpl(String referenceType, String referenceId, String parentId, Boolean isDeleted, Boolean isSortByCreatedACS) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)7);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 5;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 6;
        Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 7;
        Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, CommentEntity>(){

            public LimitOffsetDataSource<CommentEntity> create() {
                return new LimitOffsetDataSource<CommentEntity>(EkoCommentDao_Impl.this.__db, _statement, false, true, new String[]{"comment", "comment_flag"}){

                    protected List<CommentEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentId");
                        int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"path");
                        int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceType");
                        int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceId");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parentId");
                        int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"rootId");
                        int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dataType");
                        int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dataTypes");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"data");
                        int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"attachments");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childrenNumber");
                        int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                        int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactions");
                        int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionCount");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"editedAt");
                        int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"syncState");
                        int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"segmentNumber");
                        int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"mentionees");
                        int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetType");
                        int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetId");
                        int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"myReactions");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"expiresAt");
                        ArrayList<CommentEntity> _res = new ArrayList<CommentEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            String _tmpCommentId = cursor.isNull(_cursorIndexOfCommentId) ? null : cursor.getString(_cursorIndexOfCommentId);
                            String _tmpPath = cursor.isNull(_cursorIndexOfPath) ? null : cursor.getString(_cursorIndexOfPath);
                            String _tmpReferenceType = cursor.isNull(_cursorIndexOfReferenceType) ? null : cursor.getString(_cursorIndexOfReferenceType);
                            String _tmpReferenceId = cursor.isNull(_cursorIndexOfReferenceId) ? null : cursor.getString(_cursorIndexOfReferenceId);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            String _tmpParentId = cursor.isNull(_cursorIndexOfParentId) ? null : cursor.getString(_cursorIndexOfParentId);
                            String _tmpRootId = cursor.isNull(_cursorIndexOfRootId) ? null : cursor.getString(_cursorIndexOfRootId);
                            String _tmpDataType = cursor.isNull(_cursorIndexOfDataType) ? null : cursor.getString(_cursorIndexOfDataType);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfDataTypes) ? null : cursor.getString(_cursorIndexOfDataTypes);
                            List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_4);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfData) ? null : cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfAttachments) ? null : cursor.getString(_cursorIndexOfAttachments);
                            JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_6);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                            int _tmpChildrenNumber = cursor.getInt(_cursorIndexOfChildrenNumber);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfReactions) ? null : cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_8);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            int _tmp_9 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_9 != 0;
                            String _tmp_10 = cursor.isNull(_cursorIndexOfEditedAt) ? null : cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            String _tmpSyncState = cursor.isNull(_cursorIndexOfSyncState) ? null : cursor.getString(_cursorIndexOfSyncState);
                            int _tmpSegmentNumber = cursor.getInt(_cursorIndexOfSegmentNumber);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfMentionees) ? null : cursor.getString(_cursorIndexOfMentionees);
                            List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_11);
                            String _tmpTargetType = cursor.isNull(_cursorIndexOfTargetType) ? null : cursor.getString(_cursorIndexOfTargetType);
                            String _tmpTargetId = cursor.isNull(_cursorIndexOfTargetId) ? null : cursor.getString(_cursorIndexOfTargetId);
                            CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                            String _tmp_12 = cursor.isNull(_cursorIndexOfMyReactions) ? null : cursor.getString(_cursorIndexOfMyReactions);
                            List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_12);
                            _item.setMyReactions(_tmpMyReactions);
                            String _tmp_13 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_14 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmp_15 = cursor.isNull(_cursorIndexOfExpiresAt) ? null : cursor.getString(_cursorIndexOfExpiresAt);
                            DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                            _item.setExpiresAt(_tmpExpiresAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommentEntity> getAllByParentIdImpl(String referenceType, String referenceId, Boolean isDeleted, Boolean isSortByCreatedACS) {
        Integer _tmp_3;
        Integer _tmp_2;
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId is null and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.referenceId = ? and comment.parentId is null and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)6);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 5;
        Integer n3 = isSortByCreatedACS == null ? null : (_tmp_2 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 6;
        Integer n4 = isSortByCreatedACS == null ? null : (_tmp_3 = Integer.valueOf(isSortByCreatedACS != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, CommentEntity>(){

            public LimitOffsetDataSource<CommentEntity> create() {
                return new LimitOffsetDataSource<CommentEntity>(EkoCommentDao_Impl.this.__db, _statement, false, true, new String[]{"comment", "comment_flag"}){

                    protected List<CommentEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"commentId");
                        int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"path");
                        int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceType");
                        int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"referenceId");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"parentId");
                        int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"rootId");
                        int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dataType");
                        int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dataTypes");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"data");
                        int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"attachments");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childrenNumber");
                        int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"flagCount");
                        int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactions");
                        int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reactionCount");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"editedAt");
                        int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"syncState");
                        int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"segmentNumber");
                        int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"mentionees");
                        int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetType");
                        int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"targetId");
                        int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"myReactions");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"expiresAt");
                        ArrayList<CommentEntity> _res = new ArrayList<CommentEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            String _tmpCommentId = cursor.isNull(_cursorIndexOfCommentId) ? null : cursor.getString(_cursorIndexOfCommentId);
                            String _tmpPath = cursor.isNull(_cursorIndexOfPath) ? null : cursor.getString(_cursorIndexOfPath);
                            String _tmpReferenceType = cursor.isNull(_cursorIndexOfReferenceType) ? null : cursor.getString(_cursorIndexOfReferenceType);
                            String _tmpReferenceId = cursor.isNull(_cursorIndexOfReferenceId) ? null : cursor.getString(_cursorIndexOfReferenceId);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            String _tmpParentId = cursor.isNull(_cursorIndexOfParentId) ? null : cursor.getString(_cursorIndexOfParentId);
                            String _tmpRootId = cursor.isNull(_cursorIndexOfRootId) ? null : cursor.getString(_cursorIndexOfRootId);
                            String _tmpDataType = cursor.isNull(_cursorIndexOfDataType) ? null : cursor.getString(_cursorIndexOfDataType);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfDataTypes) ? null : cursor.getString(_cursorIndexOfDataTypes);
                            List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_4);
                            String _tmp_5 = cursor.isNull(_cursorIndexOfData) ? null : cursor.getString(_cursorIndexOfData);
                            JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfAttachments) ? null : cursor.getString(_cursorIndexOfAttachments);
                            JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_6);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                            int _tmpChildrenNumber = cursor.getInt(_cursorIndexOfChildrenNumber);
                            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfReactions) ? null : cursor.getString(_cursorIndexOfReactions);
                            AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_8);
                            int _tmpReactionCount = cursor.getInt(_cursorIndexOfReactionCount);
                            int _tmp_9 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_9 != 0;
                            String _tmp_10 = cursor.isNull(_cursorIndexOfEditedAt) ? null : cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            String _tmpSyncState = cursor.isNull(_cursorIndexOfSyncState) ? null : cursor.getString(_cursorIndexOfSyncState);
                            int _tmpSegmentNumber = cursor.getInt(_cursorIndexOfSegmentNumber);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfMentionees) ? null : cursor.getString(_cursorIndexOfMentionees);
                            List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_11);
                            String _tmpTargetType = cursor.isNull(_cursorIndexOfTargetType) ? null : cursor.getString(_cursorIndexOfTargetType);
                            String _tmpTargetId = cursor.isNull(_cursorIndexOfTargetId) ? null : cursor.getString(_cursorIndexOfTargetId);
                            CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                            String _tmp_12 = cursor.isNull(_cursorIndexOfMyReactions) ? null : cursor.getString(_cursorIndexOfMyReactions);
                            List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_12);
                            _item.setMyReactions(_tmpMyReactions);
                            String _tmp_13 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_14 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmp_15 = cursor.isNull(_cursorIndexOfExpiresAt) ? null : cursor.getString(_cursorIndexOfExpiresAt);
                            DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                            _item.setExpiresAt(_tmpExpiresAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    Flowable<CommentEntity> getLatestParentCommentImpl(String referenceType, String referenceId, Boolean isDeleted, int hash, int nonce, DateTime now) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from comment, amity_paging_id where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.parentId is null and comment.updatedAt > ? and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by comment.updatedAt  desc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment, amity_paging_id where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.parentId is null and comment.updatedAt > ? and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by comment.updatedAt  desc limit 1", (int)7);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 4;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 5;
        String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_2);
        }
        _argIndex = 6;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 7;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment", "amity_paging_id"}, (Callable)new Callable<CommentEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommentEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CommentEntity _result;
                    int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                        List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                        JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_7);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_8 != 0;
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_10);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_11);
                        _result.setMyReactions(_tmpMyReactions);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    CommentEntity commentEntity = _result;
                    return commentEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<CommentEntity> getLatestChildCommentImpl(String referenceType, String referenceId, String parentId, Boolean isDeleted, int hash, int nonce, DateTime now) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from comment, amity_paging_id where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.parentId = ? and comment.updatedAt > ? and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by comment.createdAt  desc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment, amity_paging_id where comment.referenceType = ? and comment.referenceId = ? and comment.isDeleted = (case when ? is null then isDeleted else ? end) and comment.parentId = ? and comment.updatedAt > ? and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by comment.createdAt  desc limit 1", (int)8);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 4;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 5;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 6;
        String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_2);
        }
        _argIndex = 7;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 8;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment", "amity_paging_id"}, (Callable)new Callable<CommentEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommentEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CommentEntity _result;
                    int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                        List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                        JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_7);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_8 != 0;
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_10);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_11);
                        _result.setMyReactions(_tmpMyReactions);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    CommentEntity commentEntity = _result;
                    return commentEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommentEntity> getLatestCommentsImpl(String referenceType, String referenceId) {
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.referenceId = ? and comment.commentId = comment_flag.commentId and comment.isDeleted = 0 and comment.parentId is null order by createdAt DESC LIMIT 5";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = ? and comment.referenceId = ? and comment.commentId = comment_flag.commentId and comment.isDeleted = 0 and comment.parentId is null order by createdAt DESC LIMIT 5", (int)2);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_5 != 0;
                String _tmp_6 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_8);
                _item.setMyReactions(_tmpMyReactions);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                _item.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                _item.setExpiresAt(_tmpExpiresAt);
                _result.add(_item);
            }
            ArrayList<CommentEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommentEntity> getLatestRepliesImpl(String parentId, String referenceType, String referenceId, boolean isSortByCreatedACS) {
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.parentId = ? and comment.referenceId = ? and comment.referenceType = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc LIMIT 5";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.parentId = ? and comment.referenceId = ? and comment.referenceType = ? and comment.commentId = comment_flag.commentId order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc LIMIT 5", (int)5);
        int _argIndex = 1;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 4;
        int _tmp = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 5;
        int _tmp_1 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp_2);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_4);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_6);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_7 != 0;
                String _tmp_8 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_9);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_10);
                _item.setMyReactions(_tmpMyReactions);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_12 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                _item.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_13 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                _item.setExpiresAt(_tmpExpiresAt);
                _result.add(_item);
            }
            ArrayList<CommentEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<List<CommentEntity>> observeCommentAfterImpl(String referenceType, String referenceId, boolean isSortByCreatedACS, DateTime offsetCommentTime) {
        String _sql = "SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)5);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(offsetCommentTime);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 4;
        int _tmp_1 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 5;
        int _tmp_2 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment"}, (Callable)new Callable<List<CommentEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CommentEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                        List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                        JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_7);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_8 != 0;
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_10);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_11);
                        _item.setMyReactions(_tmpMyReactions);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item);
                    }
                    ArrayList<CommentEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<List<CommentEntity>> observeCommentAfterFilterByParentImpl(String referenceType, String referenceId, String parentId, boolean isSortByCreatedACS, DateTime offsetCommentTime) {
        String _sql = "SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.parentId = ? and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment where comment.referenceType = ? and comment.referenceId = ? and comment.parentId = ? and comment.createdAt > ? order by case when ? = 1 then comment.createdAt end asc, case when ? = 0 then comment.createdAt end desc", (int)6);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        if (parentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, parentId);
        }
        _argIndex = 4;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(offsetCommentTime);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 5;
        int _tmp_1 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 6;
        int _tmp_2 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment"}, (Callable)new Callable<List<CommentEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CommentEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                        List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                        JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_5);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_7);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_8 != 0;
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_10);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        CommentEntity _item = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_11);
                        _item.setMyReactions(_tmpMyReactions);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_13 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_14 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                        _item.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item);
                    }
                    ArrayList<CommentEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateTime getCommentCreatedTime(String commentId) {
        String _sql = "SELECT createdAt from comment where commentId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT createdAt from comment where commentId = ?", (int)1);
        int _argIndex = 1;
        if (commentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, commentId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            DateTime _result;
            if (_cursor.moveToFirst()) {
                String _tmp = _cursor.isNull(0) ? null : _cursor.getString(0);
                _result = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
            } else {
                _result = null;
            }
            DateTime dateTime = _result;
            return dateTime;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CommentEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from comment where comment.commentId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment where comment.commentId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            CommentEntity _result;
            int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_5 != 0;
                String _tmp_6 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_8);
                _result.setMyReactions(_tmpMyReactions);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            CommentEntity commentEntity = _result;
            return commentEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommentEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from comment where comment.commentId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
            int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
            int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
            int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                List<String> _tmpDataTypes = this.__stringListConverter.stringToStringList(_tmp);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                JsonArray _tmpAttachments = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_5 != 0;
                String _tmp_6 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                CommentEntity _item_1 = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                List<String> _tmpMyReactions = this.__stringListConverter.stringToStringList(_tmp_8);
                _item_1.setMyReactions(_tmpMyReactions);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_10 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_11 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<CommentEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<CommentEntity> getByIdImpl(String commentId) {
        String _sql = "SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.commentId = ? and comment.commentId = comment_flag.commentId LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.commentId = ? and comment.commentId = comment_flag.commentId LIMIT 1", (int)1);
        int _argIndex = 1;
        if (commentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, commentId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment", "comment_flag"}, (Callable)new Callable<CommentEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommentEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CommentEntity _result;
                    int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        String _tmp = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                        List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                        JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_5 != 0;
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_8);
                        _result.setMyReactions(_tmpMyReactions);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    CommentEntity commentEntity = _result;
                    return commentEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<List<CommentEntity>> getByCommentIdsImpl(List<String> commentIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from comment where comment.commentId IN (");
        int _inputSize = commentIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : commentIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment"}, (Callable)new Callable<List<CommentEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CommentEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfReferenceType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceType");
                    int _cursorIndexOfReferenceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"referenceId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfParentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parentId");
                    int _cursorIndexOfRootId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rootId");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfDataTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataTypes");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfAttachments = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attachments");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfChildrenNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"childrenNumber");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfEditedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"editedAt");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfSegmentNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"segmentNumber");
                    int _cursorIndexOfMentionees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mentionees");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfMyReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"myReactions");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    ArrayList<CommentEntity> _result = new ArrayList<CommentEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        String _tmpReferenceType = _cursor.isNull(_cursorIndexOfReferenceType) ? null : _cursor.getString(_cursorIndexOfReferenceType);
                        String _tmpReferenceId = _cursor.isNull(_cursorIndexOfReferenceId) ? null : _cursor.getString(_cursorIndexOfReferenceId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        String _tmpParentId = _cursor.isNull(_cursorIndexOfParentId) ? null : _cursor.getString(_cursorIndexOfParentId);
                        String _tmpRootId = _cursor.isNull(_cursorIndexOfRootId) ? null : _cursor.getString(_cursorIndexOfRootId);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        String _tmp = _cursor.isNull(_cursorIndexOfDataTypes) ? null : _cursor.getString(_cursorIndexOfDataTypes);
                        List<String> _tmpDataTypes = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfAttachments) ? null : _cursor.getString(_cursorIndexOfAttachments);
                        JsonArray _tmpAttachments = EkoCommentDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommentDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                        int _tmpChildrenNumber = _cursor.getInt(_cursorIndexOfChildrenNumber);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = EkoCommentDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_5 != 0;
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfEditedAt) ? null : _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        int _tmpSegmentNumber = _cursor.getInt(_cursorIndexOfSegmentNumber);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfMentionees) ? null : _cursor.getString(_cursorIndexOfMentionees);
                        List<EkoMentioneesDto> _tmpMentionees = EkoCommentDao_Impl.this.__mentioneesConverter.jsonToMentionees(_tmp_7);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        CommentEntity _item_1 = new CommentEntity(_tmpCommentId, _tmpPath, _tmpReferenceType, _tmpReferenceId, _tmpUserId, _tmpParentId, _tmpRootId, _tmpDataType, _tmpDataTypes, _tmpData, _tmpAttachments, _tmpMetadata, _tmpChildrenNumber, _tmpFlagCount, _tmpReactions, _tmpReactionCount, _tmpIsDeleted, _tmpEditedAt, _tmpSyncState, _tmpSegmentNumber, _tmpMentionees, _tmpTargetType, _tmpTargetId);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfMyReactions) ? null : _cursor.getString(_cursorIndexOfMyReactions);
                        List<String> _tmpMyReactions = EkoCommentDao_Impl.this.__stringListConverter.stringToStringList(_tmp_8);
                        _item_1.setMyReactions(_tmpMyReactions);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _item_1.setCreatedAt(_tmpCreatedAt);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _item_1.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommentDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _item_1.setExpiresAt(_tmpExpiresAt);
                        _result.add(_item_1);
                    }
                    ArrayList<CommentEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

