package com.ekoapp.ekosdk.internal.api

import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint
import com.ekoapp.ekosdk.internal.data.EkoDatabase
import com.ekoapp.ekosdk.internal.data.model.AmityUploadUrl
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl
import io.reactivex.rxjava3.core.Flowable

internal object EkoEndpoint {
    private var httpUrl = ""
    private var socketUrl = ""
    private var mqttUrl = ""
    private var uploadUrl = ""

    fun getHttpUrl(): String {
        val storedUrl = EkoDatabase.get().httpUrlDao().currentHttpUrl
                .defaultIfEmpty(EkoHttpUrl.create(AmityEndpoint.SG.httpEndpoint))
                .blockingGet()
                .httpUrl
        if(storedUrl != httpUrl) {
            httpUrl = storedUrl
        }
        return httpUrl
    }

    fun observeHttpUrl(): Flowable<String> {
        return EkoDatabase.get().httpUrlDao().observeCurrentHttpUrl()
            .map {
                it.httpUrl
            }
    }

    fun getSocketUrl(): String {
        val storedUrl = EkoDatabase.get().socketUrlDao().currentSocketUrl
                .defaultIfEmpty(EkoSocketUrl.create(AmityEndpoint.SG.socketEndpoint))
                .blockingGet()
                .socketUrl
        if(storedUrl != socketUrl) {
            socketUrl = storedUrl
        }
        return socketUrl
    }

    fun getMqttUrl(): String {
        val storedUrl = EkoDatabase.get().mqttUrlDao().currentMqttUrl
            .defaultIfEmpty(EkoMqttUrl.create(AmityEndpoint.SG.mqttEndpoint))
            .blockingGet()
            .mqttUrl
        if(storedUrl != mqttUrl) {
            mqttUrl = storedUrl
        }
        return mqttUrl
    }

    fun getUploadUrl(): String {
        val storedUrl = EkoDatabase.get().uploadUrlDao().currentUploadUrl
            .defaultIfEmpty(AmityUploadUrl.create(AmityEndpoint.SG.uploadEndpoint))
            .blockingGet()
            .uploadUrl
        if(storedUrl != uploadUrl) {
            uploadUrl = storedUrl
        }
        return uploadUrl
    }

}