/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.core;

import com.amity.socialcloud.sdk.api.core.ads.AmityAdRepository;
import com.amity.socialcloud.sdk.api.core.encryption.AmityDBEncryption;
import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint;
import com.amity.socialcloud.sdk.api.core.events.AmityTopicSubscription;
import com.amity.socialcloud.sdk.api.core.file.AmityFileRepository;
import com.amity.socialcloud.sdk.api.core.notification.AmityNotification;
import com.amity.socialcloud.sdk.api.core.permission.AmityPermissionValidator;
import com.amity.socialcloud.sdk.api.core.presence.AmityPresenceService;
import com.amity.socialcloud.sdk.api.core.presence.AmityUserPresenceRepository;
import com.amity.socialcloud.sdk.api.core.reaction.AmityReactionRepository;
import com.amity.socialcloud.sdk.api.core.session.AmitySessionEstablisher;
import com.amity.socialcloud.sdk.api.core.user.AmityUserRepository;
import com.amity.socialcloud.sdk.api.core.user.notification.AmityUserNotification;
import com.amity.socialcloud.sdk.api.core.user.update.AmityUserUpdate;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.domain.networksettings.ValidateTextsUseCase;
import com.amity.socialcloud.sdk.core.domain.networksettings.ValidateUrlsUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.RegisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterAllUsersForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.domain.session.LogoutUseCase;
import com.amity.socialcloud.sdk.core.domain.session.SecureLogoutUseCase;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.core.content.AmityContentCheck;
import com.amity.socialcloud.sdk.model.core.events.AmityTopic;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermission;
import com.amity.socialcloud.sdk.model.core.session.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.model.core.session.SessionHandler;
import com.amity.socialcloud.sdk.model.core.unread.UserUnread;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.streamapi.AmityClientConfiguration;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.data.stream.StreamFunction;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.usecase.content.GetContentCheckUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0007J\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0006\u0010#\u001a\u00020\u0004J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020/H\u0007J\u0006\u00100\u001a\u000201J\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013J\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0013J\u0006\u00105\u001a\u000206J\b\u00107\u001a\u00020\u0004H\u0007J\u0006\u00108\u001a\u00020\u0004J\u0006\u00109\u001a\u00020\u0004J\"\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\n2\b\b\u0002\u0010<\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020?J\b\u0010@\u001a\u00020\bH\u0007J\b\u0010A\u001a\u00020\bH\u0007J\b\u0010B\u001a\u00020\bH\u0007J\b\u0010C\u001a\u00020\bH\u0007J\u000e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\b\u0010H\u001a\u00020\u0004H\u0007J\u0006\u0010I\u001a\u00020\u0004J\b\u0010J\u001a\u00020\u0006H\u0007J\u0014\u0010K\u001a\u00020\u00042\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\n0MJ\u0014\u0010N\u001a\u00020\u00042\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\n0M\u00a8\u0006P"}, d2={"Lcom/amity/socialcloud/sdk/api/core/AmityCoreClient;", "", "()V", "disconnect", "Lio/reactivex/rxjava3/core/Completable;", "editUser", "Lcom/amity/socialcloud/sdk/api/core/user/update/AmityUserUpdate$Builder;", "enableUnreadCount", "", "getAmityCoreSdkVersion", "", "getConfiguration", "Lcom/amity/socialcloud/sdk/streamapi/AmityClientConfiguration;", "getContentCheck", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentCheck;", "getCurrentSessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getCurrentUser", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "getGlobalBanEvents", "Lcom/amity/socialcloud/sdk/model/core/session/AmityGlobalBanEvent;", "getTotalUnreadCount", "", "getUserId", "hasPermission", "Lcom/amity/socialcloud/sdk/api/core/permission/AmityPermissionValidator;", "permission", "Lcom/amity/socialcloud/sdk/model/core/permission/AmityPermission;", "login", "Lcom/amity/socialcloud/sdk/api/core/session/AmitySessionEstablisher$Builder;", "userId", "sessionHandler", "Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "logout", "newAdRepository", "Lcom/amity/socialcloud/sdk/api/core/ads/AmityAdRepository;", "newFileRepository", "Lcom/amity/socialcloud/sdk/api/core/file/AmityFileRepository;", "newReactionRepository", "Lcom/amity/socialcloud/sdk/api/core/reaction/AmityReactionRepository;", "newUserPresenceRepository", "Lcom/amity/socialcloud/sdk/api/core/presence/AmityUserPresenceRepository;", "newUserRepository", "Lcom/amity/socialcloud/sdk/api/core/user/AmityUserRepository;", "notification", "Lcom/amity/socialcloud/sdk/api/core/user/notification/AmityUserNotification;", "notifications", "Lcom/amity/socialcloud/sdk/api/core/notification/AmityNotification;", "observeSessionState", "observeUserUnread", "Lcom/amity/socialcloud/sdk/model/core/unread/UserUnread;", "presence", "Lcom/amity/socialcloud/sdk/api/core/presence/AmityPresenceService;", "registerDeviceForPushNotification", "registerPushNotification", "secureLogout", "setup", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/api/core/endpoint/AmityEndpoint;", "dbEncryption", "Lcom/amity/socialcloud/sdk/api/core/encryption/AmityDBEncryption;", "startUnreadCountSyncing", "startUnreadSync", "stopUnreadCountSyncing", "stopUnreadSync", "subscription", "Lcom/amity/socialcloud/sdk/api/core/events/AmityTopicSubscription;", "topic", "Lcom/amity/socialcloud/sdk/model/core/events/AmityTopic;", "unregisterDeviceForPushNotification", "unregisterPushNotification", "updateUser", "validateTexts", "texts", "", "validateUrls", "urls", "amity-sdk_release"})
public final class AmityCoreClient {
    @NotNull
    public static final AmityCoreClient INSTANCE = new AmityCoreClient();

    private AmityCoreClient() {
    }

    @NotNull
    public final SessionState getCurrentSessionState() {
        return CoreClient.INSTANCE.getCurrentSessionState();
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint, @NotNull AmityDBEncryption dbEncryption) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dbEncryption, (String)"dbEncryption");
        return CoreClient.INSTANCE.setup(apiKey, endpoint, dbEncryption);
    }

    public static /* synthetic */ Completable setup$default(AmityCoreClient amityCoreClient, String string, AmityEndpoint amityEndpoint, AmityDBEncryption amityDBEncryption, int n, Object object) {
        if ((n & 2) != 0) {
            amityEndpoint = AmityEndpoint.SG.INSTANCE;
        }
        if ((n & 4) != 0) {
            amityDBEncryption = AmityDBEncryption.NONE.INSTANCE;
        }
        return amityCoreClient.setup(string, amityEndpoint, amityDBEncryption);
    }

    @Deprecated(message="Use registerPushNotification() instead")
    @NotNull
    public final Completable registerDeviceForPushNotification() {
        return this.registerPushNotification();
    }

    @Deprecated(message="Use unregisterPushNotification() instead")
    @NotNull
    public final Completable unregisterDeviceForPushNotification() {
        return this.unregisterPushNotification();
    }

    @NotNull
    public final Completable registerPushNotification() {
        return new RegisterDeviceForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable unregisterPushNotification() {
        return new UnregisterAllUsersForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable disconnect() {
        return CoreClient.INSTANCE.disconnect();
    }

    @NotNull
    public final AmitySessionEstablisher.Builder login(@NotNull String userId, @Nullable SessionHandler sessionHandler) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return CoreClient.INSTANCE.login(userId, sessionHandler);
    }

    @NotNull
    public final Completable logout() {
        return new LogoutUseCase().execute();
    }

    @NotNull
    public final Completable secureLogout() {
        return new SecureLogoutUseCase().execute();
    }

    @NotNull
    public final String getUserId() {
        return new ActiveUserIdGetUseCase().execute();
    }

    @NotNull
    public final AmityUserUpdate.Builder editUser() {
        return new AmityUserUpdate.Builder(this.getUserId());
    }

    @Deprecated(message="Use editUser() instead")
    @NotNull
    public final AmityUserUpdate.Builder updateUser() {
        return this.editUser();
    }

    @NotNull
    public final AmityPermissionValidator hasPermission(@NotNull AmityPermission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)permission), (String)"permission");
        return new AmityPermissionValidator(permission);
    }

    @NotNull
    public final Flowable<AmityUser> getCurrentUser() {
        return this.newUserRepository().getCurrentUser();
    }

    @NotNull
    public final AmityUserRepository newUserRepository() {
        return new AmityUserRepository();
    }

    @NotNull
    public final AmityAdRepository newAdRepository() {
        return new AmityAdRepository();
    }

    @NotNull
    public final AmityFileRepository newFileRepository() {
        return new AmityFileRepository();
    }

    @NotNull
    public final AmityReactionRepository newReactionRepository() {
        return new AmityReactionRepository();
    }

    @NotNull
    public final String getAmityCoreSdkVersion() {
        return "6.35.0";
    }

    @NotNull
    public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        return EkoSocket.Companion.getGlobalBanEvents();
    }

    @Deprecated(message="Use notifications.user() instead")
    @NotNull
    public final AmityUserNotification notification() {
        return new AmityUserNotification();
    }

    @NotNull
    public final AmityNotification notifications() {
        return new AmityNotification();
    }

    @NotNull
    public final AmityClientConfiguration getConfiguration() {
        return new AmityClientConfiguration((StreamFunctionInterface)new StreamFunction());
    }

    @NotNull
    public final AmityTopicSubscription subscription(@NotNull AmityTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return new AmityTopicSubscription(topic);
    }

    @NotNull
    public final Single<AmityContentCheck> getContentCheck() {
        return new GetContentCheckUseCase().execute();
    }

    @NotNull
    public final Flowable<SessionState> observeSessionState() {
        return CoreClient.INSTANCE.observeSessionState();
    }

    @Deprecated(message="Using enableUnreadCount() instead", replaceWith=@ReplaceWith(expression="AmityCoreClient.enableUnreadCount()", imports={"com.amity.socialcloud.sdk.api.core.AmityCoreClient"}))
    public final void startUnreadCountSyncing() {
        CoreClient.INSTANCE.startMarkerSyncing();
    }

    @Deprecated(message="Using enableUnreadCount() instead", replaceWith=@ReplaceWith(expression="AmityCoreClient.enableUnreadCount()", imports={"com.amity.socialcloud.sdk.api.core.AmityCoreClient"}))
    public final void startUnreadSync() {
        CoreClient.INSTANCE.startMarkerSyncing();
    }

    @Deprecated(message="Remove this if changing to use enableUnreadCount()")
    public final void stopUnreadCountSyncing() {
        CoreClient.INSTANCE.stopMarkerSyncing();
    }

    @Deprecated(message="Remove this if changing to use enableUnreadCount()")
    public final void stopUnreadSync() {
        CoreClient.INSTANCE.stopMarkerSyncing();
    }

    @Deprecated(message="Use observeUserUnread() instead")
    @NotNull
    public final Flowable<Integer> getTotalUnreadCount() {
        return CoreClient.INSTANCE.observeUserUnreadCount();
    }

    @NotNull
    public final Flowable<UserUnread> observeUserUnread() {
        return CoreClient.INSTANCE.observeUserUnread();
    }

    @NotNull
    public final AmityPresenceService presence() {
        return CoreClient.INSTANCE.presence();
    }

    @NotNull
    public final AmityUserPresenceRepository newUserPresenceRepository() {
        return CoreClient.INSTANCE.newUserPresenceRepository();
    }

    public final void enableUnreadCount() {
        CoreClient.INSTANCE.enableUnreadCount();
    }

    @NotNull
    public final Completable validateUrls(@NotNull List<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        return new ValidateUrlsUseCase().execute(urls);
    }

    @NotNull
    public final Completable validateTexts(@NotNull List<String> texts) {
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        return new ValidateTextsUseCase().execute(texts);
    }
}

