package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class SubChannelUnreadInfoDao : EkoObjectDao<SubChannelUnreadInfoEntity>() {
	@Query("SELECT * from sub_channel_unread_info where subChannelId = :subChannelId LIMIT 1")
	abstract fun getById(subChannelId: String): Flowable<SubChannelUnreadInfoEntity>
	
	@Query("SELECT * from sub_channel_unread_info where subChannelId = :subChannelId LIMIT 1")
	abstract override fun getByIdNow(subChannelId: String): SubChannelUnreadInfoEntity?
	
	@Query("DELETE from sub_channel_unread_info")
	abstract override fun deleteAll()
	
	@Query("UPDATE sub_channel_unread_info SET isDeleted = 1 where subChannelId = :subChannelId")
	abstract fun deleteById(subChannelId: String)
	
	@Query("UPDATE sub_channel_unread_info SET isDeleted = 1 where channelId = :channelId")
	abstract fun deleteByChannelId(channelId: String)
	
	@Query("SELECT * from sub_channel_unread_info where channelId = :channelId and isDeleted = 0")
	abstract fun getByChannelIdNow(channelId: String): List<SubChannelUnreadInfoEntity>
	
	@Query("SELECT subChannelId from sub_channel_unread_info where subChannelId in (:subChannelIds) and isDeleted = 1")
	abstract fun getDeletedIds(subChannelIds: List<String>): List<String>
}