package com.amity.socialcloud.sdk.social.domain.community.member

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.member.query.AmityCommunityMembershipSortOption
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMember
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMembership
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipRepository
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class SearchCommunityMembershipPagingSourceUseCase {

    fun execute(
        communityId: String,
        roles: AmityRoles,
        communityMembership: List<AmityCommunityMembership>?,
        sortBy: AmityCommunityMembershipSortOption,
        keyword: String
    ): Flowable<PagingData<AmityCommunityMember>> {
        return CommunityMembershipRepository().searchCommunityMembershipPagingData(
            communityId,
            roles,
            communityMembership,
            sortBy,
            keyword
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { member ->
                CommunityMemberComposerUseCase().execute(member)
            }
        }
    }

}