package com.amity.socialcloud.sdk.chat.domain.marker.channel

import com.amity.socialcloud.sdk.chat.data.marker.channel.ChannelMarkerRepository
import com.ekoapp.ekosdk.internal.ChannelUnreadInfoEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import org.joda.time.DateTime

internal class ReCalculateChannelUnreadInfoUseCase {
	
	fun execute(channelId: String) {
		val subChannelUnreadInfo = UserDatabase.get().subChannelUnreadInfoDao().getByChannelIdNow(channelId)
		val channelUnreadInfo = ChannelUnreadInfoEntity().apply {
			this.channelId = channelId
			this.unreadCount = subChannelUnreadInfo.sumOf {
				it.calculateUnreadCount()
			}
			this.isMentioned = subChannelUnreadInfo.fold(false) { acc, subChannelUnreadInfoEntity ->
				acc || subChannelUnreadInfoEntity.calculateIsMentioned()
			}
			this.createdAt = DateTime.now()
			this.updatedAt = DateTime.now()
		}
		ChannelMarkerRepository().saveChannelUnreadInfo(listOf(channelUnreadInfo))
	}
}