package com.ekoapp.ekosdk.internal.api.http

import co.amity.rxupload.RxUploadService
import com.amity.socialcloud.sdk.AmityOkHttp
import com.ekoapp.ekosdk.internal.api.EkoEndpoint


internal class AmityUploadService {

    companion object {
        fun initService() {
            val url = EkoEndpoint.getHttpUrl()
            val fileSizeLimitInBytes = MAX_FILE_SIZE
            val interceptors = listOf(AmityLoggingInterceptor(), AmityAuthenticationInterceptor())
            val settings = RxUploadService.Settings.Builder
                    .maximumFileSize(fileSizeLimitInBytes.toInt())
                    .build()

            RxUploadService.init(
                baseUrl = url,
                settings = settings,
                interceptors = interceptors,
                certificatePinner = AmityOkHttp.certificatePinner()
            )
        }
    }

}

private const val MAX_FILE_SIZE: Long = 1073741824 // size in Bytes, equivalent to 1 GB
