package com.amity.socialcloud.sdk

import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint
import com.ekoapp.ekosdk.internal.api.EkoEndpoint
import com.ekoapp.ekosdk.internal.api.http.AmityAuthenticationInterceptor
import com.ekoapp.ekosdk.internal.api.http.AmityLoggingInterceptor
import com.ekoapp.ekosdk.internal.api.http.AmityTimeoutInterceptor
import com.ekoapp.ekosdk.sdk.BuildConfig
import okhttp3.*
import java.net.Proxy
import java.net.ProxySelector
import java.net.URI

internal class AmityOkHttp {
    companion object {
        private val OK_CONNECTION_POOL = ConnectionPool()
        private val OK_DISPATCHER = Dispatcher()

        internal fun newBuilder(): OkHttpClient.Builder {
            return OkHttpClient.Builder()
                .connectionPool(OK_CONNECTION_POOL)
                .dispatcher(OK_DISPATCHER)
                .protocols(listOf(Protocol.HTTP_1_1))
                .addNetworkInterceptor(AmityLoggingInterceptor())
                .addNetworkInterceptor(AmityAuthenticationInterceptor())
                .addInterceptor(AmityTimeoutInterceptor())
                .also {
                    certificatePinner()?.let { pinner ->
                        it.certificatePinner(pinner)
                    }
                }.also {
                    //debug build only
                    //enabling proxy for interception testing
                    //as okhttp has its own proxy settings which by default is Proxy.NONE
                    //https://github.com/square/okhttp/issues/2525
                    if (BuildConfig.DEBUG) {
                        val proxies: List<Proxy> =
                            ProxySelector.getDefault().select(URI.create("https://www.google.com"))
                        if (proxies.isNotEmpty() && proxies[0] !== Proxy.NO_PROXY) {
                            //Force OkHttp to always use the first proxy if found
                            it.proxy(proxies[0])
                        }
                    }
                }
        }

        internal fun certificatePinner(): CertificatePinner? {
            val currentEndpoint = EkoEndpoint.getHttpUrl()
            if (currentEndpoint == AmityEndpoint.SG.httpEndpoint
                || currentEndpoint == AmityEndpoint.EU.httpEndpoint
                || currentEndpoint == AmityEndpoint.US.httpEndpoint
                || currentEndpoint == "https://true-apix.amity.co"
            ) {
                val uri = URI(currentEndpoint)
                val path: String = uri.host
                return CertificatePinner.Builder()
                    // Pin CAs for the current domain
                    // Amazon Root CA1
                    .add(path, "sha256/++MBgDH5WGvL9Bcn5Be30cRcL0f5O+NyoXuWtQdX1aI=")
                    // Amazon Root CA2
                    .add(path, "sha256/f0KW/FtqTjs108NpYj42SrGvOB2PpxIVM8nWxjPqJGE=")
                    // Amazon Root CA3
                    .add(path, "sha256/XqvDJlas/GRcYbcWE8S/IceH9cq77kg0jVhZeAPXq8k=")
                    // Amazon Root CA4
                    .add(path, "sha256/9+ze1cZgR9KO1kZrVDxA4HQ6voHRCSVNz4RdTCx4U8U=")
                    // Amazon Root Starfield Services CA
                    .add(path, "sha256/KwccWaCgrnaw6tsrrSO61FgLacNgG2MMLq8GE6+oP5I=")
                    // ISRG Root X1
                    .add(path, "sha256/C5+lpZ7tcVwmwQIMcRtPbsQtWLABXhQzejna0wHFr8M=")
                    // ISRG Root X2
                    .add(path, "sha256/diGVwiVYbubAI3RW4hB9xU8e/CH2GnkuvVFZE8zmgzI=")
                    .build()
            }
            return null
        }
    }

}