package com.amity.socialcloud.sdk.social.domain.story.markclicked

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsService
import com.amity.socialcloud.sdk.model.social.story.AmityStory

internal class MarkStoryAsClickedUseCase {

    fun execute(story: AmityStory) {
        if(story.getState() != AmityStory.State.SYNCED) {
            return
        }
        AnalyticsService().markStoryAsClicked(story.getStoryId())
    }
}