package com.amity.socialcloud.sdk.social.data.poll

import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.dto.EkoPollQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.PollCreateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.PollUpdateRequest
import com.ekoapp.ekosdk.internal.api.socket.request.PollVoteRequest
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface PollApi {

    @POST("api/v3/polls")
    fun createPoll(
        @Body request: PollCreateRequest
    ): Single<EkoPollQueryDto>

    @PUT("api/v3/polls/{pollId}")
    fun updatePoll(
        @Path("pollId") pollId: String? = null,
        @Body request: PollUpdateRequest
    ): Single<EkoPollQueryDto>

    @DELETE("api/v3/polls/{pollId}")
    fun deletePoll(
        @Path("pollId") pollId: String? = null
    ): Single<EkoDeletionDto>

    @POST("api/v3/polls/{pollId}/votes")
    fun votePoll(
        @Path("pollId") pollId: String? = null,
        @Body request: PollVoteRequest
    ): Single<EkoPollQueryDto>
}