package com.amity.socialcloud.sdk.core.engine.analytics.capturer

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority
import io.reactivex.rxjava3.schedulers.Schedulers
import org.joda.time.DateTime

internal abstract class AnalyticsEventCapturer(
    private val contentType: String,
    private val activityType: String,
    private val syncPriority: AnalyticsEventSyncPriority
) {

    private val recentCaptured : HashMap<String, DateTime?> = hashMapOf()

    fun captureEvent(
        contentId: String,
    ) {
        if (recentCaptured[contentId]?.plusSeconds(5)?.isAfterNow == true) {
            // just recently capture this event, ignore the event.
            return
        }

        // cooldown is off, let's process this event.
        AnalyticsRepository().saveAnalyticEvent(
            contentId = contentId,
            contentType = contentType,
            activityType = activityType,
            syncPriority = syncPriority
        )
            .subscribeOn(Schedulers.io())
            .doOnComplete {
                recentCaptured[contentId] = DateTime.now()
            }
            .doOnError {

            }
            .subscribe()
    }

}