package com.amity.socialcloud.sdk.chat.data.marker.channel

import com.ekoapp.ekosdk.internal.api.dto.ChannelMarkerQueryDto
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface ChannelMarkerApi {

    @GET("api/v1/markers/channels")
    fun queryChannelMarkers(
        @Query("channelIds[]") channelIds: List<String>? = null
    ): Single<ChannelMarkerQueryDto>
    
    @PUT("api/v1/markers/channels/{channelId}/mark-read")
    fun markChannelAsRead(
        @Path("channelId") channelId: String
    ): Single<ChannelMarkerQueryDto>
}