package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Query;

import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSortOption;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;

import java.util.List;

import io.reactivex.rxjava3.core.Flowable;

@Dao
public abstract class UserDao extends EkoObjectDao<UserEntity> implements AmityPagingDao<UserEntity> {

    @Query(
            "SELECT *" +
                    " from user, user_query_token" +
                    " where (user.displayName like '%' || :keyword || '%' or user.userId like '%' || :keyword || '%')" +
                    " and" +
                    " (user_query_token.keyword = :keyword" +
                    " and user_query_token.sortBy = :sortBy" +
                    " and user_query_token.ids like '%' || user.userId || '%')" +
                    " order by user.displayName asc"
    )
    abstract PagingSource<Integer, UserEntity> getPagingSourceImpl(String keyword, String sortBy);

    public PagingSource<Integer, UserEntity> getPagingSource(String keyword, AmityUserSortOption sortBy) {
        return getPagingSourceImpl(keyword, sortBy.getApiKey());
    }

    @Query("SELECT *" +
            " from user" +
            " where user.userId = :userId" +
            " LIMIT 1")
    abstract Flowable<UserEntity> getByIdImpl(String userId);

    public Flowable<UserEntity> getById(String userId) {
        return getByIdImpl(userId);
    }

    @Query("SELECT *" +
            " from user" +
            " where user.userId IN (:userId)")
    abstract Flowable<List<UserEntity>> observeUserImpl(String userId);

    public Flowable<List<UserEntity>> observeUser(String userId) {
        return observeUserImpl(userId);
    }

    @Query("DELETE from user where userId = :userId")
    public abstract void deleteById(String userId);

    @Query("SELECT *" +
            " from user" +
            " where user.userId = :userId" +
            " LIMIT 1")
    abstract UserEntity getByIdNowImpl(String userId);

    public UserEntity getByIdNow(String userId) {
        return getByIdNowImpl(userId);
    }

    @Query("SELECT *" +
            " from user" +
            " where user.userId IN (:userIds)")
    abstract List<UserEntity> getByIdsNowImpl(List<String> userIds);


    @Override
    public List<UserEntity> getByIdsNow(List<String> ids) {
        return getByIdsNowImpl(ids);
    }

    public Flowable<List<UserEntity>> getByUserIds(List<String> ids) {
        return getByUserIdsImpl(ids);
    }

    @Query("SELECT *" +
            " from user" +
            " where user.userId IN (:userIds)")
    abstract Flowable<List<UserEntity>> getByUserIdsImpl(List<String> userIds);

    @Query("DELETE from user")
    public abstract void deleteAll();
}
