package com.amity.socialcloud.sdk.video.data.stream

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.video.EkoStreamDto
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamEntity

internal class StreamEntityMapper : EntityMapper<EkoStreamDto, EkoStreamEntity>() {

    override fun map(list: List<EkoStreamDto>): List<EkoStreamEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: EkoStreamDto) : EkoStreamEntity {
        return EkoStreamEntity().apply {
            streamId = dto.streamId
            moderationId = dto.moderationId ?: ""
            title = dto.title
            description = dto.description
            metadata = dto.metadata
            status = dto.status
            isReconnecting = dto.isReconnecting
            userId = dto.userId
            thumbnailFileId = dto.thumbnailFileId
            setCreatedAt(dto.createdAt)
            setUpdatedAt(dto.updatedAt)
            watcherData = dto.watcherData
            broadcasterData = dto.broadcasterData
            recordings = dto.recordings
            resolution = dto.resolution
            isDeleted = dto.isDeleted
        }
    }

}