package com.amity.socialcloud.sdk.model.core.role

import android.os.Parcelable
import kotlinx.android.parcel.Parcelize

@Parcelize
class AmityRoles(private val roles: List<String>) : ArrayList<String>(roles), Parcelable {

    constructor() : this(mutableListOf())

    constructor(roles: Set<String>) : this(roles.toList())

    fun get() : List<String> {
        return this.filter { it.isNotEmpty() }
    }

}