package com.amity.socialcloud.sdk.entity.core.user

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "user")
open class UserEntity(
    @PrimaryKey
    var userId: String = ObjectId.get().toHexString(),
    var mid: String = "",
    var path: String = "",
    var displayName: String? = null,
    var roles: AmityRoles? = null,
    var permissions: AmityPermissions? = null,
    var flagCount: Int = 0,
    var metadata: JsonObject? = null,
    var avatarFileId: String? = null,
    var avatarCustomUrl: String? = null,
    var description: String? = null,
    var isGlobalBan: Boolean = false,
    var isDeleted: Boolean = false,
    var lastHeartbeat: DateTime? = null
) : EkoObject() {

    override fun getId(): String {
        return userId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        if (other.javaClass != javaClass) return false
        return (Objects.equal(userId, (other as UserEntity).userId)
                && Objects.equal(mid, other.mid)
                && Objects.equal(path, other.path)
                && Objects.equal(displayName, other.displayName)
                && Objects.equal(roles, other.roles)
                && Objects.equal(permissions, other.permissions)
                && Objects.equal(flagCount, other.flagCount)
                && Objects.equal(metadata, other.metadata)
                && Objects.equal(avatarFileId, other.avatarFileId)
                && Objects.equal(avatarCustomUrl, other.avatarCustomUrl)
                && Objects.equal(description, other.description)
                && Objects.equal(isGlobalBan, other.isGlobalBan)
                && Objects.equal(lastHeartbeat, other.lastHeartbeat))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            userId,
            mid,
            path,
            displayName,
            roles,
            permissions,
            flagCount,
            metadata,
            avatarFileId,
            avatarCustomUrl,
            description,
            isGlobalBan,
            lastHeartbeat
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper): String {
        toStringHelper.add("userId", userId)
            .add("mid", mid)
            .add("path", path)
            .add("displayName", displayName)
            .add("roles", roles)
            .add("permissions", permissions)
            .add("flagCount", flagCount)
            .add("metadata", metadata)
            .add("avatarFileId", avatarFileId)
            .add("avatarCustomUrl", avatarCustomUrl)
            .add("description", description)
            .add("isGlobalBan", isGlobalBan)
            .add("lastHeartbeat", lastHeartbeat)
        return super.internalToString(toStringHelper)
    }

}
