package com.amity.socialcloud.sdk.core.presence

import kotlin.random.Random

internal class PresenceConfig(
    private val isSyncEnabled: Boolean = false,
    private val heartbeatSyncInterval: Long? = null,
    private val presenceSyncInterval: Long? = null,
) {

    fun isSyncEnabled() = isSyncEnabled

    fun getHeartbeatSyncInterval(): Long? {
        return if (heartbeatSyncInterval == null) {
            null
        } else {
            heartbeatSyncInterval * 1000 + jitter
        }
    }

    fun getPresenceSyncInterval(): Long? {
        return if (presenceSyncInterval == null) {
            null
        } else {
            presenceSyncInterval * 1000 + jitter
        }
    }

    companion object {

        val ONLINE_THRESHOLD = 60

        val SYNC_CONFIG_RETRY_INTERVAL: Long
            get() = 10 * 1000L + jitter

        val jitter get() = Random.nextLong(1000, 5000)
    }
}
