package com.amity.socialcloud.sdk.api.social.post.reaction

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.ekoapp.ekosdk.internal.usecase.post.ReactionPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

@Deprecated("Use AmityCoreClient.newReactionRepository().getReactions() instead")
class AmityPostReactionQuery private constructor(
    private val postId: String,
    private val reactionName: String?
) {

    fun query(): Flowable<PagingData<AmityReaction>> {
        return ReactionPagingDataUseCase().execute(AmityReactionReferenceType.POST, postId, reactionName)
    }

    class Builder internal constructor(private val postId: String) {

        private var reactionName: String? = null

        fun reactionName(reactionName: String): Builder {
            return apply { this.reactionName = reactionName }
        }

        fun build(): AmityPostReactionQuery {
            return AmityPostReactionQuery(postId, reactionName)
        }
    }

}