package com.amity.socialcloud.sdk.api.social.comment.query

import com.amity.socialcloud.sdk.model.social.comment.CommentType

class AmityCommentQueryType internal constructor() {

    /**
     * Specifies the post that the comments were created on
     * @param [postId] a postId of a post
     * @return new instance of AmityLatestCommentQuery.Builder
     */
    fun post(postId: String): AmityCommentQuery.Builder {
        return AmityCommentQuery.Builder()
                .referenceType(CommentType.POST.value)
                .referenceId(postId)
    }

    /**
     * Specifies the story that the comments were created on
     * @param [storyId] a postId of a post
     * @return new instance of AmityLatestCommentQuery.Builder
     */
    fun story(storyId: String): AmityCommentQuery.Builder {
        return AmityCommentQuery.Builder()
            .referenceType(CommentType.STORY.value)
            .referenceId(storyId)
    }

    /**
     * Specifies the content that the comments were created on
     * @param [contentId] a contentId
     * @return new instance of AmityLatestCommentQuery.Builder
     */
    fun content(contentId: String): AmityCommentQuery.Builder {
        return AmityCommentQuery.Builder()
                .referenceType(CommentType.CONTENT.value)
                .referenceId(contentId)
    }

}