package com.amity.socialcloud.sdk.api.chat.message.flag

import com.amity.socialcloud.sdk.api.core.flag.AmityFlagger
import com.ekoapp.ekosdk.internal.usecase.message.FlagMessageUseCase
import com.ekoapp.ekosdk.internal.usecase.message.UnFlagMessageUseCase
import io.reactivex.rxjava3.core.Completable

class AmityMessageFlagger internal constructor(private val messageId: String) : AmityFlagger() {

    @Deprecated(
        message = "This function is deprecated, please use AmityChatClient.newMessageRepository().flagMessage() instead",
        replaceWith = ReplaceWith(
            "AmityChatClient.newMessageRepository().flagMessage()",
            "com.amity.socialcloud.sdk.api.chat.message.AmityMessageRepository"
        ),
    )
    fun flag(): Completable {
        return FlagMessageUseCase().execute(messageId)
    }

    @Deprecated(
        message = "This function is deprecated, please use AmityChatClient.newMessageRepository().unflagMessage() instead",
        replaceWith = ReplaceWith(
            "AmityChatClient.newMessageRepository().unflagMessage()",
            "com.amity.socialcloud.sdk.api.chat.message.AmityMessageRepository"
        ),
    )
    fun unflag(): Completable {
        return UnFlagMessageUseCase().execute(messageId)
    }
    /* end_public_function */

}